package com.tandbergtv.watchpoint.studio.ui.editor.expression;

import java.util.Collection;

import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;

public class ExpressionUtil {

	/**
	 * 		Default packages/classes to be imported in the expression context.
	 */
	public static final String[] DEFAULT_IMPORTS = {
		"java.io.*",
		"java.util.*"
	};

	/**
	 * 		Converts the Studio variables into Java variables.
	 * 
	 * @param variables
	 * @return
	 */
	public static String toJavaVariableStr(Collection<? extends Variable> variables) {
		/* Adds the context variables as class member variables  
		   in order to validate the class properly.
		   EG: String templateVariable; */
		StringBuilder memberVariables = new StringBuilder();
		for (Variable var : variables) {
			WPVariable wpVar = (WPVariable) var;
            if (wpVar.isNameValid()) {
                DataType varType = DataType.STRING;
                try {
                    varType = DataType.valueOf(wpVar.getType());
                } catch (IllegalArgumentException e) {
                    // unable to figure out data type... default to String
                }

                memberVariables.append(varType.getJavaMatchingType());
                memberVariables.append(" ");
                memberVariables.append(wpVar.getName());
                
                if (varType == DataType.LIST)
                	memberVariables.append(" = new ArrayList<String>();");
                else if (varType == DataType.INT)
                	memberVariables.append(" = 0;");
                else
                	memberVariables.append(" = null;");
            }
		}
		return memberVariables.toString();
	}
}