/*
 * Created on Sep 20, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.AdaptorTypeSectionPart;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.CustomAdaptorSectionPart;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.DefaultAdaptorSectionPart;

/**
 * The ResourceType Form Page containing the Adaptor Configuration Controls
 * 
 * @author Vijay Silva
 */
public class AdaptorPage extends ResourceTypeFormPage
{
	private static final String PAGE_TITLE = "Adaptor";

	private static final String PAGE_HEADER = "Adaptor Configuration";

	public static final String PAGE_ID = "ResourceType.AdaptorPage";

	AdaptorTypeSectionPart typePart;

	DefaultAdaptorSectionPart defaultPart;

	CustomAdaptorSectionPart customPart;

	Composite configComposite;

	StackLayout configLayout;

	/**
	 * @param editor
	 *            The Parent Editor
	 */
	public AdaptorPage(ResourceTypeEditor editor)
	{
		super(editor, PAGE_ID, PAGE_TITLE);
	}

	/*
	 * Create the Controls displayed in the composite
	 */
	@Override
	protected void createPageControls()
	{
		IManagedForm managedForm = this.getManagedForm();
		ScrolledForm form = managedForm.getForm();
		form.setText(PAGE_HEADER);

		Composite formBody = form.getBody();
		FormToolkit toolkit = managedForm.getToolkit();

		/* Create the Adaptor Type Section Part */
		int style = getDefaultSectionStyle();
		this.typePart = new AdaptorTypeSectionPart(this, formBody, toolkit, style);
		this.typePart.getSection().setText("Adaptor Type");
		managedForm.addPart(this.typePart);

		/* Create the Composite that contains the Default and Custom Adaptor configuration */
		this.configComposite = toolkit.createComposite(formBody);
		toolkit.paintBordersFor(configComposite);

		/* Create the Default Adaptor Section Part */
		this.defaultPart = new DefaultAdaptorSectionPart(this, this.configComposite, toolkit, style);
		this.defaultPart.getSection().setText("Default Adaptor Configuration");
		managedForm.addPart(this.defaultPart);

		/* Create the Default Adaptor Section Part */
		this.customPart = new CustomAdaptorSectionPart(this, this.configComposite, toolkit, style);
		this.customPart.getSection().setText("Custom Adaptor Configuration");
		managedForm.addPart(this.customPart);

		this.typePart.getTypeCombo().addSelectionListener(new TypeSelectionListener());
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.ResourceTypeFormPage#initializePageLayout()
	 */
	@Override
	protected void initializePageLayout()
	{
		Composite formBody = this.getManagedForm().getForm().getBody();

		/* Set the Form Layout */
		formBody.setLayout(this.createGridLayout(1, false));

		/* Set the Layout Data for the Sections in the Form */
		this.typePart.getSection().setLayoutData(this.createSectionGridData());
		this.configComposite.setLayoutData(this.createSectionGridData());

		configLayout = new StackLayout();
		configLayout.topControl = null;
		this.configComposite.setLayout(configLayout);
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.ResourceTypeFormPage#populatePageData()
	 */
	@Override
	protected void populatePageData()
	{
		super.populatePageData();
		this.handleTypeSelection();
	}

	// ========================================================================
	// ===================== EVENT HANDLING
	// ========================================================================

	private void handleTypeSelection()
	{
		AdaptorType adaptorType = this.typePart.getAdaptorType();
		if (adaptorType == null)
			adaptorType = AdaptorType.NONE;

		Control topControl = null;
		switch (adaptorType)
		{
			case DEFAULT:
				topControl = this.defaultPart.getSection();
				break;

			case CUSTOM:
				topControl = this.customPart.getSection();
				break;
		}

		if (this.configLayout.topControl != topControl)
		{
			this.configLayout.topControl = topControl;
			this.configComposite.layout();
		}
	}

	// ========================================================================
	// ===================== SELECTION LISTENER FOR THE TYPE COMBO
	// ========================================================================

	/* Selection Listener for the type combo */
	class TypeSelectionListener implements SelectionListener
	{
		/**
		 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		public void widgetDefaultSelected(SelectionEvent event)
		{
			AdaptorPage.this.handleTypeSelection();
		}

		/**
		 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		public void widgetSelected(SelectionEvent event)
		{
			AdaptorPage.this.handleTypeSelection();
		}
	}
}
