/*
 * Created on Sep 18, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.GeneralSectionPart;

/**
 * The Basic Properties Control that displays the basic properties for a Resource Type.
 * 
 * @author Vijay Silva
 */
public class GeneralPage extends ResourceTypeFormPage
{
	private static final String PAGE_TITLE = "General";

	public static final String PAGE_ID = "ResourceType.GeneralPage";

	protected GeneralSectionPart generalSectionPart;

	/**
	 * @param editor
	 *            The parent editor
	 */
	public GeneralPage(ResourceTypeEditor editor)
	{
		super(editor, PAGE_ID, PAGE_TITLE);
	}

	/*
	 * Create the Controls displayed in the composite
	 */
	@Override
	protected void createPageControls()
	{
		IManagedForm managedForm = this.getManagedForm();
		ScrolledForm form = managedForm.getForm();
		form.setText(PAGE_TITLE);

		Composite formBody = form.getBody();
		FormToolkit toolkit = managedForm.getToolkit();

		/* Create the Section Part */
		int style = getDefaultSectionStyle();
		this.generalSectionPart = new GeneralSectionPart(this, formBody, toolkit, style);
		this.generalSectionPart.getSection().setText("General Information");

		managedForm.addPart(this.generalSectionPart);
	}

	/*
	 * Create the Form Layout
	 */
	@Override
	protected void initializePageLayout()
	{
		Composite formBody = this.getManagedForm().getForm().getBody();

		/* Set the Form Layout */
		formBody.setLayout(this.createGridLayout(1, false));

		/* Set the Layout Data for the Section in the Form */
		this.generalSectionPart.getSection().setLayoutData(this.createSectionGridData());
	}
}
