/*
 * Created on Sep 28, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.ResourceTypeFormPage;

/**
 * The Master Details block that displays the list of Messages and the Message details
 * 
 * @author Vijay Silva
 */
public class MessagesMasterDetailsBlock extends MasterDetailsBlock
{
	Composite masterComposite;

	MessageMasterSectionPart messagesSectionPart;

	MessageDetailsPage messageDetailsPage;

	IEditorPart editorPart;

	/**
	 * Constructor
	 * 
	 * @param parentPart
	 *            The Part that contains this composite
	 */
	public MessagesMasterDetailsBlock(IEditorPart parentPart)
	{
		this.editorPart = parentPart;
	}

	/**
	 * @see org.eclipse.ui.forms.MasterDetailsBlock#createMasterPart(org.eclipse.ui.forms.IManagedForm,
	 *      org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected void createMasterPart(IManagedForm managedForm, Composite parent)
	{
		FormToolkit toolkit = managedForm.getToolkit();

		this.masterComposite = toolkit.createComposite(parent);
		toolkit.paintBordersFor(this.masterComposite);
		this.messagesSectionPart = new MessageMasterSectionPart(this.editorPart,
				this.masterComposite, toolkit, ResourceTypeFormPage.getDefaultSectionStyle());

		Section messagesSection = this.messagesSectionPart.getSection();
		messagesSection.setText("Messages");
		managedForm.addPart(this.messagesSectionPart);

		/* Layout */
		this.masterComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		GridLayout gridLayout = new GridLayout(1, false);
		gridLayout.marginLeft = gridLayout.marginRight = 0;
		gridLayout.marginTop = gridLayout.marginBottom = 0;
		gridLayout.marginHeight = gridLayout.marginWidth = 10;
		masterComposite.setLayout(gridLayout);

		messagesSection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
	}

	/**
	 * @see org.eclipse.ui.forms.MasterDetailsBlock#createToolBarActions(org.eclipse.ui.forms.IManagedForm)
	 */
	@Override
	protected void createToolBarActions(IManagedForm managedForm)
	{ /* Do Nothing */
	}

	/**
	 * @see org.eclipse.ui.forms.MasterDetailsBlock#registerPages(org.eclipse.ui.forms.DetailsPart)
	 */
	@Override
	protected void registerPages(DetailsPart detailsPart)
	{
		detailsPart.setPageLimit(2);

		this.messageDetailsPage = new MessageDetailsPage(this.editorPart, this.messagesSectionPart);
		detailsPart.registerPage(MessageInput.class, this.messageDetailsPage);
	}
}
