/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.model;

import org.jbpm.gd.common.model.SemanticElement;

/**
 * Parent interface for all elements which can have a due date.
 * 
 * @author Imran Naqvi
 * 
 */
public interface IDueDateElement extends SemanticElement{

	/**
	 * Sets the due date of the element.
	 * 
	 * @param dueDate
	 */
	void setDueDate(String dueDate);

	/**
	 * Gets the due date of the element.
	 * 
	 * @return The due date value
	 */
	String getDueDate();
}
