package com.tandbergtv.watchpoint.studio.ui.model;

import org.jbpm.gd.common.model.AbstractSemanticElement;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.SuperState;

import com.tandbergtv.watchpoint.studio.util.SemanticElementCloneUtil;

/**
 * Model representation of a super state.
 * 
 * @author Imran Naqvi
 * 
 */
public class NodeGroup extends SuperState implements IDueDateElement,
		IResourceGroupElement {

	private static final String SUPERSTATE_ENTER_EVENT = "superstate-enter";

	private static final String SUPERSTATE_LEAVE_EVENT = "superstate-leave";

	ResourceGroup resourceGroup = null;

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement#getResourceGroup()
	 */
	public ResourceGroup getResourceGroup() {
		return this.resourceGroup;
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement#setResourceGroup(com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup)
	 */
	public void setResourceGroup(ResourceGroup group) {
		this.resourceGroup = group;
		firePropertyChange("resourceGroupAdd", null, resourceGroup);
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement#getDueDate()
	 */
	public String getDueDate() {
		CreateTimer createTimer = null;

		for (Event event : this.getEvents()) {
			if (event.getType().equals(SUPERSTATE_ENTER_EVENT)) {
				for (ActionElement action : event.getActionElements())
					if (action instanceof CreateTimer)
						createTimer = (CreateTimer) action;
			}
		}
		if (createTimer == null)
			return null;

		return createTimer.getDueDate();
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement#setDueDate(java.lang.String)
	 */
	public void setDueDate(String dueDate) {
		CreateTimer createTimer = getNodeEnterCreateTimer();
		if (createTimer == null)
			return;
		createTimer.setDueDate(dueDate);
	}

	/*
	 * Gets the create timer for this node. Creates a new create timer if none exists.
	 */
	private CreateTimer getNodeEnterCreateTimer() {
		Event nodeEnterEvent = addTimerActionToEvent(SUPERSTATE_ENTER_EVENT,
				TemplateActionRefNames.TIMER_FIRE_ACTION);

		/* Add timer delete action */
		addTimerActionToEvent(SUPERSTATE_LEAVE_EVENT, TemplateActionRefNames.TIMER_DELETE_ACTION);

		for (ActionElement action : nodeEnterEvent.getActionElements())
			if (action instanceof CreateTimer)
				return (CreateTimer) action;
		return null;
	}

	/*
	 * Adds a Create Timer or a delete timer action to the corresponding event.
	 */
	private Event addTimerActionToEvent(String eventName, String timerAction) {
		boolean newEvent = false;
		Event nodeEvent = null;
		/* Find node enter event */
		for (Event event : this.getEvents()) {
			if (!event.getType().equals(eventName))
				continue;
			nodeEvent = event;
		}

		/* Create node enter event if it does not exist */
		if (nodeEvent == null) {
			nodeEvent = (Event) getFactory().createById(
					SemanticElementConstants.EVENT_SEID);
			/* Add node enter event */
			this.addEvent(nodeEvent);
			nodeEvent.setType(eventName);
			newEvent = true;
		}
		Action action = null;

		if (eventName.equals(SUPERSTATE_ENTER_EVENT)) {
			CreateTimer createTimer = null;
			if (!newEvent) {
				/* Find create timer action */
				for (ActionElement actionElement : nodeEvent.getActionElements()) {
					if (!(actionElement instanceof CreateTimer))
						continue;
					createTimer = (CreateTimer) actionElement;
				}
			}
			/* Create create timer action if it does not exist */
			if (createTimer == null) {
				createTimer = (CreateTimer) getFactory().createById(
						SemanticElementConstants.CREATE_TIMER_SEID);
				/* Add create timer action */
				nodeEvent.addActionElement(createTimer);
			}
			action = createTimer.getAction();
			if (action == null) {
				action = (Action) getFactory().createById(
						SemanticElementConstants.ACTION_SEID);
				createTimer.setAction(action);
			}
		}
		else if (eventName.equals(SUPERSTATE_LEAVE_EVENT)) {
			for (ActionElement actionElement : nodeEvent.getActionElements()) {
				if (actionElement instanceof Action
						&& ((Action) actionElement).getRefName() != null &&
						((Action) actionElement).getRefName().equals(timerAction))
					action = (Action) actionElement;
			}
			if (action == null) {
				action = (Action) getFactory().createById(
						SemanticElementConstants.ACTION_SEID);
				nodeEvent.addActionElement(action);
			}
		}

		action.setRefName(timerAction);

		return nodeEvent;
	}
	
	public NodeGroup cloneNodeGroup(){
		return SemanticElementCloneUtil.cloneNodeGroup(this);
	}

    @Override
    public void addNodeElement(NodeElement node) {
        ((WPNodeElement) node).setParent(this);
        super.addNodeElement(node);
    }

    @Override
    public void removeNodeElement(NodeElement node) {
        if (node != null) {
            ((WPNodeElement) node).setParent(null);
        }
        super.removeNodeElement(node);
    }

    @Override
    public void accept(SemanticElementVisitor visitor) {
        for (NodeElement nodeElement : getNodeElements()) {
            ((AbstractSemanticElement)nodeElement).accept(visitor);
        }
        visitor.visit(this);
   }
}