package com.tandbergtv.watchpoint.studio.ui.preferences;

import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

import com.tandbergtv.watchpoint.studio.ui.WatchPointStudioPlugin;

public class ValidationLevelConfigurationBlock extends com.tandbergtv.watchpoint.studio.eclipse.custom.ValidationLevelConfigurationBlock {

	private static final String SETTINGS_SECTION_NAME= "ValidationLevelConfigurationBlock";  //$NON-NLS-1$
	
    private static Map<KeyAndValue, List<KeyAndValue>> itemsBySections;

	// values
	private static final String ERROR= JavaCore.ERROR;
	private static final String WARNING= JavaCore.WARNING;
	private static final String IGNORE= JavaCore.IGNORE;


	private FilteredPreferenceTree fFilteredPrefTree;

	public ValidationLevelConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
		super(context, project, container);
	}

	static {
        itemsBySections = SectionStructureReader.readStructure();
        initializeKeyPool(itemsBySections);
	}
	

	
    private static void initializeKeyPool(Map<KeyAndValue, List<KeyAndValue>> itemsBySections) {
        for (KeyAndValue sectionModel : itemsBySections.keySet()) {
            putKey(sectionModel.getKey());
            for (KeyAndValue itemModel : itemsBySections.get(sectionModel)) {
                putKey(itemModel.getKey());
            }
        }
    }
    
    private static void putKey(String keyStr) {
        if (keyPool.get(keyStr) == null) {
        	keyPool.put(keyStr, new WatchpointStudioKey(keyStr));
        }
    }
    
    @Override
	protected Composite createStyleTabContent(Composite folder) {
		String[] errorWarningIgnore= new String[] { ERROR, WARNING, IGNORE };

		String[] errorWarningIgnoreLabels= new String[] {
			org.eclipse.jdt.internal.ui.preferences.PreferencesMessages.ProblemSeveritiesConfigurationBlock_error,
			org.eclipse.jdt.internal.ui.preferences.PreferencesMessages.ProblemSeveritiesConfigurationBlock_warning,
			org.eclipse.jdt.internal.ui.preferences.PreferencesMessages.ProblemSeveritiesConfigurationBlock_ignore
		};

		fFilteredPrefTree= new FilteredPreferenceTree(this, folder, PreferencesMessages.ValidationLevelConfigurationBlock_common_description);
		final ScrolledPageContent sc1= fFilteredPrefTree.getScrolledPageContent();
		
		int nColumns= 3;
		Composite composite= setComposite(sc1,nColumns);
		int indentStep=  fPixelConverter.convertWidthInCharsToPixels(1);

		int defaultIndent= indentStep * 0;
		String label;
		ExpandableComposite excomposite;
		Composite inner;
		PreferenceTreeNode section;
		Key twistieKey;

		// --- style

        for (KeyAndValue sectionModel : itemsBySections.keySet()) {
            label = sectionModel.getValue();
            twistieKey = OptionsConfigurationBlock.getLocalKey(sectionModel.getKey());
            section = fFilteredPrefTree.addExpandableComposite(composite, label, nColumns, twistieKey, null, false);
            excomposite = getExpandableComposite(twistieKey);

            inner = createInnerComposite(excomposite, nColumns, composite.getFont());

            for (KeyAndValue itemModel : itemsBySections.get(sectionModel)) {
                label = itemModel.getValue();
                fFilteredPrefTree.addComboBox(inner, label, keyPool.get(itemModel.getKey()), errorWarningIgnore,
                        errorWarningIgnoreLabels, defaultIndent, section);
            }
        }

		IDialogSettings settingsSection= WatchPointStudioPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_NAME);
		restoreSectionExpansionStates(settingsSection);

		return sc1;
	}


	/* (non-Javadoc)
	 * @see org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock#dispose()
	 */
	@Override
	public void dispose() {
		IDialogSettings section= WatchPointStudioPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION_NAME);
		storeSectionExpansionStates(section);
		super.dispose();
	}
}
