package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableColumn;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

public class MessageNodeVariablesInSuperStateLabelProviderOut extends WPLabelProvider {

    public MessageNodeVariablesInSuperStateLabelProviderOut(TableColumn attachmentColumn) {
        this.columns = new TableColumn[] { attachmentColumn };
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        WPVariable model = (WPVariable) element;
        if (columnIndex == 1) {
            return getCheckImage(model.isAttachment());
        }
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
        case 0:
            return ((WPVariable) element).getMappedName();
        case 2:
            return ((WPVariable) element).getValue();
        case 3:
            return ((WPVariable) element).getName();
        }
        return null;
    }

    @Override
    protected int getColumnIndex(Event event) {
        return event.index - 1;
    }
}