/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class MessageNodeVariablesInSuperStateSectionComposite {

    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Composite composite;
    private Label labelOut;
    private Table tableOut;
    private TableViewer tableViewerOut;
    private Label labelIn;
    private Table tableIn;
    private TableViewer tableViewerIn;
    private String[] columnTitlesOut = new String[] { "Name", "Attachment", "Value", "Message node variable" };
    private String[] columnTitlesIn = new String[] { "Name", "Message node variable", "Composite key" };

    private MessageNodeVariablesInSuperStateCellModifierOut cellModifierOut;
    private MessageNodeVariablesInSuperStateCellModifierIn cellModifierIn;
    private TableColumn attachmentColumnOut;
    private TableColumn compositeKeyColumnIn;
    private Composite exclusiveTableParentOut;

    public MessageNodeVariablesInSuperStateSectionComposite(Composite parent,
            TabbedPropertySheetWidgetFactory widgetFactory) {
        this.parent = parent;
        this.widgetFactory = widgetFactory;

        createComponents();
    }

    private void createComponents() {
        composite = widgetFactory.createFlatFormComposite(parent);

        createLabelOut();
        createTableOut();
        createLabelIn();
        createTableIn();
        createTableViewerOut();
        createTableViewerIn();
    }

    private void createLabelOut() {
        labelOut = widgetFactory.createLabel(composite, "Define the outgoing variables:");
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment(0);
        labelOut.setLayoutData(formData);
    }

    private void createTableOut() {
        exclusiveTableParentOut = widgetFactory.createFlatFormComposite(composite);

        int tableStyle = SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.HIDE_SELECTION;
        tableOut = widgetFactory.createTable(exclusiveTableParentOut, tableStyle);
        tableOut.setLinesVisible(true);
        tableOut.setHeaderVisible(true);

        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 0);
        layoutData.top = new FormAttachment(labelOut, 0);
        layoutData.right = new FormAttachment(100, 0);
        layoutData.width = 600;
        layoutData.height = 200;
        exclusiveTableParentOut.setLayoutData(layoutData);

        TableColumn nameColumn = new TableColumn(tableOut, SWT.LEFT);
        nameColumn.setText(columnTitlesOut[0]);
        attachmentColumnOut = new TableColumn(tableOut, SWT.CENTER);
        attachmentColumnOut.setText(columnTitlesOut[1]);
        TableColumn valueColumn = new TableColumn(tableOut, SWT.LEFT);
        valueColumn.setText(columnTitlesOut[2]);
        TableColumn messageNodeVariableColumn = new TableColumn(tableOut, SWT.LEFT);
        messageNodeVariableColumn.setText(columnTitlesOut[3]);

        TableColumnLayout layout = new TableColumnLayout();
        exclusiveTableParentOut.setLayout(layout);
        layout.setColumnData(nameColumn, new ColumnWeightData(40));
        layout.setColumnData(attachmentColumnOut, new ColumnWeightData(15));
        layout.setColumnData(valueColumn, new ColumnWeightData(40));
        layout.setColumnData(messageNodeVariableColumn, new ColumnWeightData(40));
    }

    private void createLabelIn() {
        labelIn = widgetFactory.createLabel(composite, "Define the incoming variables:");
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment(exclusiveTableParentOut, 0, SWT.BOTTOM);
        labelIn.setLayoutData(formData);
    }

    private void createTableIn() {
        //table will be created in a exclusive parent in order to use TableColumnLayout
        Composite exclusiveTableParent = widgetFactory.createFlatFormComposite(composite);

        int tableStyle = SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.HIDE_SELECTION;
        tableIn = widgetFactory.createTable(exclusiveTableParent, tableStyle);
        tableIn.setLinesVisible(true);
        tableIn.setHeaderVisible(true);

        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 0);
        layoutData.top = new FormAttachment(labelIn, 0, SWT.BOTTOM);
        layoutData.right = new FormAttachment(100, 0);
        layoutData.bottom = new FormAttachment(100, 0);
        layoutData.width = 600;
        exclusiveTableParent.setLayoutData(layoutData);

        TableColumn nameColumn = new TableColumn(tableIn, SWT.LEFT);
        nameColumn.setText(columnTitlesIn[0]);
        TableColumn messageNodeVariableColumn = new TableColumn(tableIn, SWT.LEFT);
        messageNodeVariableColumn.setText(columnTitlesIn[1]);
        compositeKeyColumnIn = new TableColumn(tableIn, SWT.CENTER);
        compositeKeyColumnIn.setText(columnTitlesIn[2]);

        TableColumnLayout layout = new TableColumnLayout();
        exclusiveTableParent.setLayout(layout);
        layout.setColumnData(nameColumn, new ColumnWeightData(40));
        layout.setColumnData(messageNodeVariableColumn, new ColumnWeightData(40));
        layout.setColumnData(compositeKeyColumnIn, new ColumnWeightData(15));
    }

    private void createTableViewerOut() {
        tableViewerOut = new TableViewer(tableOut);

        tableViewerOut.setUseHashlookup(true);
        tableViewerOut.setColumnProperties(columnTitlesOut);
        tableViewerOut.setContentProvider(new MessageNodeVariablesInSuperStateContentProvider(true));
        tableViewerOut.setLabelProvider(new MessageNodeVariablesInSuperStateLabelProviderOut(attachmentColumnOut));

        CellEditor[] editors = new CellEditor[columnTitlesOut.length];
        editors[0] = new TextCellEditor(tableOut, SWT.BORDER);
        editors[1] = new CheckboxCellEditor(tableOut);
        editors[2] = new TextCellEditor(tableOut, SWT.BORDER);
        editors[3] = new ComboBoxCellEditor(tableOut, new String[0], SWT.BORDER);

        // Assign the cell editors to the viewer 
        tableViewerOut.setCellEditors(editors);

        cellModifierOut = new MessageNodeVariablesInSuperStateCellModifierOut(tableViewerOut, columnTitlesOut);

        // Set the cell modifier for the viewer
        tableViewerOut.setCellModifier(cellModifierOut);

        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewerOut, attachmentColumnOut);
        viewerColumn.setLabelProvider((CellLabelProvider) tableViewerOut.getLabelProvider());

        tableOut.pack();
    }

    private void createTableViewerIn() {
        tableViewerIn = new TableViewer(tableIn);

        tableViewerIn.setUseHashlookup(true);
        tableViewerIn.setColumnProperties(columnTitlesIn);
        tableViewerIn.setContentProvider(new MessageNodeVariablesInSuperStateContentProvider(false));
        tableViewerIn.setLabelProvider(new MessageNodeVariablesInSuperStateLabelProviderIn(compositeKeyColumnIn));

        CellEditor[] editors = new CellEditor[columnTitlesIn.length];
        editors[0] = new TextCellEditor(tableIn, SWT.BORDER);
        editors[1] = new ComboBoxCellEditor(tableIn, new String[0], SWT.BORDER);
        editors[2] = new CheckboxCellEditor(tableIn);

        // Assign the cell editors to the viewer 
        tableViewerIn.setCellEditors(editors);

        cellModifierIn = new MessageNodeVariablesInSuperStateCellModifierIn(tableViewerIn, columnTitlesIn);

        // Set the cell modifier for the viewer
        tableViewerIn.setCellModifier(cellModifierIn);

        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewerIn, compositeKeyColumnIn);
        viewerColumn.setLabelProvider((CellLabelProvider) tableViewerIn.getLabelProvider());

        tableIn.pack();
    }

    public void setInput(NodeDefinition nodeDefinition) {
        tableViewerOut.setInput(nodeDefinition);
        tableViewerIn.setInput(nodeDefinition);

        String[] nameArray = Utility.toMappedNameArray(Utility.getNodeDefinition(nodeDefinition).getVariables());
        ((ComboBoxCellEditor) tableViewerOut.getCellEditors()[3]).setItems(nameArray);
        ((ComboBoxCellEditor) tableViewerIn.getCellEditors()[1]).setItems(nameArray);

        cellModifierOut.setVariableMappedNames(nameArray);
        cellModifierIn.setVariableMappedNames(nameArray);
    }
}
