/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.NodeElement;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceTypeElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.NodeGroup;

/**
 * Composite UI for showing the resource type section.
 * 
 * @author Imran Naqvi
 * 
 */
public class ResourceTypeElementConfigurationComposite {

	private TabbedPropertySheetWidgetFactory widgetFactory;

	private Composite parent;

	private Text resourceTypeText;

	private Label resourceTypeLabel;

	private IResourceTypeElement resourceTypeElement;

	private ResourceTypeElementConfigurationComposite() {
	}

	/**
	 * Creates a ResourceTypeElementConfigurationComposite object in the parent object using the
	 * given widget factory.
	 * 
	 * @param widgetFactory
	 * @param parent
	 * @return
	 */
	public static ResourceTypeElementConfigurationComposite create(
			TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
		ResourceTypeElementConfigurationComposite result = new ResourceTypeElementConfigurationComposite();
		result.widgetFactory = widgetFactory;
		result.parent = parent;
		result.create();
		return result;
	}

	/**
	 * Sets the Resource type element and updates controls.
	 * 
	 * @param resourceTypeElement
	 */
	public void setResourceTypeElement(NodeDefinition resourceTypeElement) {
		this.resourceTypeElement = resourceTypeElement;
		if(!(resourceTypeElement.getResourceType() <= 0)) {
			String name = "undefined";
			if (resourceTypeElement.getNode() instanceof AutomaticTaskNode) {
				AutomaticTaskNode automaticNode = (AutomaticTaskNode) resourceTypeElement.getNode();
				Action actionNode = automaticNode.getAction();
				GenericElement ge = actionNode.getGenericElements()[0];
				String messageUID = ge.getValue();
				
				IResourceTypeService service = ServiceFactory.createFactory().createResourceTypeService();
				Message message = service.findMessageByUID(messageUID);
				if (message != null) {
					name = message.getResourceType().getName();
				}
			} else {
				NodeGroup group = (NodeGroup) resourceTypeElement.getNode();
				for (NodeElement ssElement : group.getNodeElements()) {
					if (ssElement instanceof NodeDefinition) {
						NodeDefinition nodeDefinition = (NodeDefinition) ssElement;
						
						IResourceTypeService service = ServiceFactory.createFactory().createResourceTypeService();
						Message message = service.findMessageByUID(nodeDefinition.getUid());
						if (message != null) {
							name = message.getResourceType().getName();
						}
						break;
					}
				}
			}
			this.resourceTypeText.setText(name);
		} else {
			// Clear the Resource Type text
			this.resourceTypeText.setText("");
		}
	}

	/*
	 * Creates the widgets for this composite.
	 * 
	 */
	private void create() {
		Composite composite = widgetFactory.createFlatFormComposite(parent);
		resourceTypeLabel = new Label(composite, SWT.NONE);
		resourceTypeLabel.setText("Resource Type");
		resourceTypeLabel.setLayoutData(createResourceTypeLabelLayoutData());
		resourceTypeLabel.setBackground(ColorConstants.white);
		resourceTypeLabel.pack();

		resourceTypeText = widgetFactory.createText(composite, "");
		resourceTypeText.setLayoutData(createResourceTypeTextLayoutData());
		if (this.resourceTypeElement instanceof NodeDefinition) {
			String defName = ((NodeDefinition) this.resourceTypeElement).getDefinitionName();
			if (defName == null || defName.trim().length() == 0)
				resourceTypeText.setEnabled(false);
		}
		this.resourceTypeText.setEnabled(false);
		resourceTypeText.pack();
	}

	/*
	 * Creates layout data for the resource type label.
	 * 
	 * @return
	 */
	private FormData createResourceTypeLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0,-6);
		data.top = new FormAttachment(0, 2);
		return data;
	}

	/*
	 * Creates layout data for the resource type combo.
	 * 
	 * @return
	 */
	private FormData createResourceTypeTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 98);
		data.top = new FormAttachment(0, 0);
		data.width = 300;
		return data;
	}
		
}
