package com.tandbergtv.watchpoint.studio.ui.view.resourcetype.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.NewSuperStateWizard;

public class CreateSuperStateAction extends AbstractNodeDefinitionAction{
	private ResourceType resourceType;
	
	@Override
	public void run(IAction action) {
		if (!Utility.closeEditor(Utility.NODEDEF_EDITOR_ID, true))
			return;
		PlatformUI.getWorkbench();
		IWorkbench workbench = PlatformUI.getWorkbench();
		NewSuperStateWizard wizard = new NewSuperStateWizard();
		
		wizard.setResourceType(resourceType);
		wizard.setResourceName(resourceType.getName());
		wizard.init(workbench, new StructuredSelection());

		WizardDialog dialog = new WizardDialog(workbench
				.getActiveWorkbenchWindow().getShell(), wizard);
		dialog.open();
		
		getTreeViewer().refresh(resourceType);
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if(!selection.isEmpty()){
			TreePath[] paths = ((TreeSelection) selection).getPaths();
			TreePath path = (paths != null) ? paths[0] : null;
			if(path != null){
				this.resourceType = (ResourceType) path.getSegment(1);
			}
		}
	}
	
}
