package com.tandbergtv.watchpoint.studio.ui.wizard;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import com.tandbergtv.watchpoint.studio.ui.UIException;

/**
 * Parent class of WatchPoint Wizard classes.
 * 
 * @author Imran Naqvi
 *
 */
public abstract class AbstractWatchPointWizard extends Wizard implements INewWizard {

	protected static final String LINE_SEPARATOR = System.getProperty("line.separator");

	private String objType;

	/**
	 * Constructor
	 * 
	 * @param objectType The name of the object type created by the wizard
	 */
	public AbstractWatchPointWizard(String objectType) {
		super();
		this.objType = objectType;
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
	}

	/**
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	public boolean performFinish() {

		if (isNameDuplicate(getObjectName())) {
			getCurrentPage().setErrorMessage("A " + this.objType + " with this name already exists.");
			return false;
		}
		openViews();
		closeEditor();

		return setupEditor();
	}

	/**
	 * 
	 * @see org.eclipse.jface.wizard.Wizard#canFinish()
	 */
	@Override
	public boolean canFinish() {
		/*
		 * The wizard can finish if there are no error messages in the page and the node definition
		 * name is not empty
		 */
		return getCurrentPage().getErrorMessage() == null && getObjectName().length() > 0;
	}

	/**
	 * Close any editor before opening the resource.
	 */
	protected void closeEditor() {
	}

	/**
	 * Gets the active page of the current workbench.
	 * 
	 * @return the activ page
	 */
	protected IWorkbenchPage getActivePage() {
		return getActiveWorkbenchWindow().getActivePage();
	}

	/**
	 * Opens the WatchPoint Studio views
	 */
	protected void openViews() {
		openPropertiesView();
		//openNodeDefinitionExplorerView();
	}

	/**
	 * Gets the active work bench window of this wizard.
	 * 
	 * @return the active work bench window of this wizard
	 */
	protected IWorkbenchWindow getActiveWorkbenchWindow() {
		return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
	}

	/**
	 * Sets up the editor associated with the newly created object.
	 * 
	 * @return the editor associated with the newly created object
	 */
	protected abstract boolean setupEditor();

	/**
	 * Gets the current page of this wizard.
	 * 
	 * @return the current page of this wizard
	 */
	protected abstract WizardPage getCurrentPage();

	/**
	 * Checks to see if an object already exists with the given name.
	 * 
	 * @param name
	 *            the name which is to be checked for duplicate
	 * @return true if a node definition exists with the given name; false otherwise
	 */
	protected abstract boolean isNameDuplicate(String name);
	
	/**
	 * Gets the name entered by the user of the object in this wizard's page
	 * @return The name
	 */
	protected abstract String getObjectName();

	/*
	 * Opens the properties view.
	 */
	private void openPropertiesView() {
		try {
			if (getActivePage().findView("org.eclipse.ui.views.PropertySheet") == null) {
				getActivePage().showView("org.eclipse.ui.views.PropertySheet");
			}
		}
		catch (PartInitException e) {
			throw new UIException("Error opening properties view.", e);
		}
	}

	/*
	 * Opens the template explorer view.
	 */
	/*private void openNodeDefinitionExplorerView() {
		try {
			if (getActivePage().findView(Utility.ID_NODEDEF_EXPLORER) == null) {
				getActivePage().showView(Utility.ID_NODEDEF_EXPLORER);
			}
		}
		catch (PartInitException e) {
			throw new UIException("Error opening Message Node Explorer view.", e);
		}
	}*/

}