package com.tandbergtv.watchpoint.studio.ui.wizard.template;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jbpm.gd.jpdl.wizard.NewProcessDefinitionWizardPageCustom;
import org.jbpm.gd.jpdl.wizard.NewWatchPointTemplateWizardCustom;

import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.util.FileUtil;

public class NewWatchPointTemplateWizard extends NewWatchPointTemplateWizardCustom {

	// The Logger
	private static final Logger logger = Logger.getLogger(NewWatchPointTemplateWizard.class);

	private static final String TEMPLATE_NAME_ATTRIBUTE_REGEX = "name=\"(.*?)\"";	
		
	public NewWatchPointTemplateWizard() {
		super();
	}
	
	@Override
	public void addPages() {
		NewProcessDefinitionWizardPageCustom page = new NewProcessDefinitionWizardPage();
		super.setPage(page);
		addPage(page);
		page.init(super.getSelection());
	}
	
	@Override
	public boolean performFinish() {
		NewProcessDefinitionWizardPageCustom page = (NewProcessDefinitionWizardPageCustom) this.getPage();
		try {
			IFolder folder = page.getProcessFolder();
			folder.create(true, true, null);
			IFile processDefinitionFile = folder.getFile(folder.getName() + "." + WorkflowTemplateDTO.TEMPLATE_DEFINITION_FILE_EXTENSION_NAME);
			processDefinitionFile.create(createInitialProcessDefinition(), true, null);
			IFile gpdFile = folder.getFile(WorkflowTemplateDTO.GPD_FILE_NAME);
			gpdFile.create(createInitialGpdInfo(), true, null);
			IFile imgFile = folder.getFile(WorkflowTemplateDTO.TEMPLATE_IMAGE_FILE_NAME);
			imgFile.create(createInitialImage(), true, null);
			IDE.openEditor(getActivePage(), processDefinitionFile);
			openPropertiesView();
			BasicNewResourceWizard.selectAndReveal(processDefinitionFile, getActiveWorkbenchWindow());
			return true;
		} catch (CoreException e) {
			logger.warn(e.getMessage(), e);
			return false;
		}
	}

	protected ByteArrayInputStream createInitialProcessDefinition() throws JavaModelException {
		NewProcessDefinitionWizardPageCustom page = super.getPage();
		byte[] templateBytes = new byte[0];
		String parName = page.getProcessFolder().getName();
		String processName = parName; //.substring(0, parName.indexOf(".par"));
		processName = "name=\"" + processName + "\"";
		InputStream in = this.getClass().getResourceAsStream(WorkflowTemplateDTO.TEMPLATE_DEFINITION_FILE_NAME);
		try {
			String template = new String(FileUtil.readFile(in));
			// Replaces the template name included in the "sample" file. 
			template = template.replaceFirst(TEMPLATE_NAME_ATTRIBUTE_REGEX, processName);
			templateBytes = template.getBytes();
		} catch (IOException e) {
			logger.error("Error loading bundled template file", e);
		}
		
		return new ByteArrayInputStream(templateBytes);
	}
	
	protected ByteArrayInputStream createInitialGpdInfo() {
		byte[] gpdBytes = new byte[0];
		InputStream in = this.getClass().getResourceAsStream(WorkflowTemplateDTO.GPD_FILE_NAME);
		try {
			gpdBytes = FileUtil.readFile(in);
		} catch (IOException e) {
			logger.error("Error loading bundled template gpd", e);
		}
		return new ByteArrayInputStream(gpdBytes);
	}
	
	protected ByteArrayInputStream createInitialImage() {
		byte[] imgBytes = new byte[0];
		InputStream in = this.getClass().getResourceAsStream(WorkflowTemplateDTO.TEMPLATE_IMAGE_FILE_NAME);
		try {
			imgBytes = FileUtil.readFile(in);
		} catch (IOException e) {
			logger.error("Error loading bundled image file", e);
		}
		return new ByteArrayInputStream(imgBytes);
	}
}
