package com.tandbergtv.watchpoint.studio.ui.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.Description;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

/**
 * The Adaptor class for a node definition.
 * 
 * @author Imran Naqvi
 * 
 */
public class NodeDefinitionDomAdapter extends XmlAdapter {
	private static Map<String, String> NODE_TYPES = null;

	/**
	 * @see org.jbpm.gd.common.xml.XmlAdapter#initialize(org.jbpm.gd.common.model.SemanticElement)
	 */
	public void initialize(SemanticElement jpdlElement) {
		super.initialize(jpdlElement);
		NodeDefinition nodeDefinition = (NodeDefinition) jpdlElement;
		if (getAttribute("name") != null && !getAttribute("name").equals(""))
			nodeDefinition.setName(getAttribute("name"));
		nodeDefinition.setDefinitionName(getAttribute("definitionName"));
		if (getAttribute("resourceType") != null && !getAttribute("resourceType").equals(""))
			nodeDefinition.setResourceType(Long.parseLong(getAttribute("resourceType")));
		/* Set Node Definition Id if its not empty */
		if (getAttribute("id") != null && !getAttribute("id").equals(""))
			nodeDefinition.setId(Long.parseLong(getAttribute("id")));
		nodeDefinition.addPropertyChangeListener(this);
	}

	/**
	 * @see org.jbpm.gd.common.xml.XmlAdapter#getNodeTypes()
	 */
	@Override
	public Map<String, String> getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap<String, String>();
			NODE_TYPES.put("nodeDefinition", "node-element");
			NODE_TYPES.put("end-state", "end-state");
			NODE_TYPES.put("auto-task", "node-element");
			NODE_TYPES.put("super-state", "node-element");
			NODE_TYPES.put("transition", "transition");
			NODE_TYPES.put("variable", "variable");
			NODE_TYPES.put("description", "description");
		}
		return NODE_TYPES;
	}

	/**
	 * @see java.beans.PropertyChangeListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		if ("auto-task".equals(evt.getPropertyName())) {
			setElement("auto-task", (SemanticElement) evt.getOldValue(),
					(SemanticElement) evt.getNewValue());
		}
		else if ("super-state".equals(evt.getPropertyName())) {
			setElement("super-state", (SemanticElement) evt.getOldValue(),
					(SemanticElement) evt.getNewValue());
		}
		else if ("transitionAdd".equals(evt.getPropertyName())) {
			addElement((Transition) evt.getNewValue());
		}
		else if ("transitionRemove".equals(evt.getPropertyName())) {
			removeElement((Transition) evt.getOldValue());
		}
		else if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String) evt.getNewValue());
		}
		else if ("resourceType".equals(evt.getPropertyName())) {
			setAttribute("resourceType", evt.getNewValue().toString());
		}
		else if ("definitionName".equals(evt.getPropertyName())) {
			setAttribute("definitionName", (String) evt.getNewValue());
		}
		else if ("id".equals(evt.getPropertyName())) {
			setAttribute("id", evt.getNewValue().toString());
		}
		else if ("variableAdd".equals(evt.getPropertyName())) {
			addElement((WPVariable) evt.getNewValue());
		}
		else if ("variableRemove".equals(evt.getPropertyName())) {
			removeElement((WPVariable) evt.getOldValue());
		}
		else if ("description".equals(evt.getPropertyName())) {
			setElement("description", (SemanticElement)evt.getOldValue(), (Description)evt.getNewValue());
		} 
	}

	/**
	 * @see org.jbpm.gd.common.xml.XmlAdapter#initialize()
	 */
	@SuppressWarnings("deprecation")
	@Override
	protected void initialize() {
		super.initialize();
		if (getSemanticElement() != null) {
			NodeDefinition nodeDefinition = (NodeDefinition) getSemanticElement();
			nodeDefinition.setNodeType(NodeDefinitionType.MessageNode);
			setAttribute("name", nodeDefinition.getName());
			setAttribute("definitionName", nodeDefinition.getDefinitionName());
			setAttribute("id", String.valueOf(nodeDefinition.getId()));
			setAttribute("resourceType", String.valueOf(nodeDefinition.getResourceType()));
			/* Adding node elements */
			addElements(nodeDefinition.getNodeElements());
			/* Adding start variables */
			if (nodeDefinition.getNode() instanceof NodeElementContainer) {
				List<WPVariable> variables = nodeDefinition.getVariables();
				addElements((WPVariable[]) variables.toArray(new WPVariable[variables.size()]));
			}
			/*Add Transitions*/
			addElements(nodeDefinition.getTransitions());
			/*Add Description*/
			addElement(nodeDefinition.getDescription());
		}
	}

	/**
	 * @see org.jbpm.gd.common.xml.XmlAdapter#doModelAdd(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void doModelAdd(XmlAdapter child) {
		String type = child.getElementType();
		SemanticElement jpdlElement = createSemanticElementFor(child);
		child.initialize(jpdlElement);
		NodeDefinition nodeDefinition = (NodeDefinition) getSemanticElement();
		if ("event".equals(type)) {
			nodeDefinition.addEvent((Event) jpdlElement);
		}
		else if ("exception-handler".equals(type)) {
			nodeDefinition.addExceptionHandler((ExceptionHandler) jpdlElement);
		}
		else if ("transition".equals(type)) {
			nodeDefinition.addTransition((Transition) jpdlElement);
		}
		else if ("auto-task".equals(type) || "super-state".equals(type)) {
			nodeDefinition.setNode((AbstractNode) jpdlElement);
		}
		else if ("description".equals(getNodeType(type))) {
			nodeDefinition.setDescription((Description) jpdlElement);
		}
		else if ("transition".equals(type)) {
			nodeDefinition.addTransition((Transition) jpdlElement);
		}
		else if ("variable".equals(type)) {
			nodeDefinition.addVariable((WPVariable) jpdlElement);
		}
		else if ("description".equals(getNodeType(type))) {
			nodeDefinition.setDescription((Description)jpdlElement);
		}
	}

	/**
	 * @see org.jbpm.gd.common.xml.XmlAdapter#doModelRemove(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void doModelRemove(XmlAdapter child) {
		String type = child.getElementType();
		NodeDefinition nodeDefinition = (NodeDefinition) getSemanticElement();
		if ("transition".equals(type)) {
			nodeDefinition.removeTransition((Transition)child.getSemanticElement());
		}
//		else if ("description".equals(getNodeType(type))) {
//			nodeDefinition.setDescription(null);
//		}
	}

	/**
	 * @see org.jbpm.gd.common.xml.XmlAdapter#doModelUpdate(java.lang.String, java.lang.String)
	 */
	@Override
	protected void doModelUpdate(String name, String newValue) {
		NodeDefinition nodeDefinition = (NodeDefinition) getSemanticElement();
		if ("name".equals(name)) {
			nodeDefinition.setName(newValue);
		}
		else if ("resourceType".equals(name)) {
			nodeDefinition.setResourceType(Long.parseLong(newValue));
		}
		else if ("definitionName".equals(name)) {
			nodeDefinition.setDefinitionName(newValue);
		}
	}
}
