package com.tandbergtv.watchpoint.studio.usermgmt;

/**
 * The User ID Generator Interface provides functionality to generate a single User Id String from
 * the User, and to generate the User given the User Id.
 * 
 * @author DReddy
 */
public interface IUserIdGenerator {

	/**
	 * Generate the User Id given a valid User object.
	 * 
	 * @param user
	 *            The User
	 * 
	 * @return the User Id generated for the User
	 * 
	 * @throws UserManagementException
	 *             Exception if the User object is invalid
	 */
	String generateUserId(User user) throws UserManagementException;

	/**
	 * Generates the User given a valid User Id.
	 * 
	 * @param userId
	 *            The User Id
	 * 
	 * @return The User Object generated from the User Id
	 * 
	 * @throws UserManagementException
	 *             Exception if the User Id is invalid
	 */
	User generateUser(String userId) throws UserManagementException;
}
