/*
 * Created on Jul 20, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.graph;

import edu.uci.ics.jung.graph.decorators.Decorator;
import edu.uci.ics.jung.utils.UserDataContainer;

/**
 * Decorator that provides type safety using Generics
 * 
 * @param <K>
 *            The type of the key maintained by the Decorator
 * @param <V>
 *            The type of the value maintained by the Decorator
 * 
 * @author Vijay Silva
 */
public class WatchPointDecorator<K, V> extends Decorator
{
	/**
	 * Constructs and initializes the decorator
	 * 
	 * @param key
	 *            The key to use when decorating a user container
	 * @param copyAction
	 *            The copy action to use when decorating the user container
	 */
	public WatchPointDecorator(K key, UserDataContainer.CopyAction copyAction)
	{
		super(key, copyAction);
	}

	/**
	 * Returns the decorated value as Number
	 * 
	 * @param udc
	 *            the graph/vertex/edge
	 * @return the value
	 */
	@SuppressWarnings("unchecked")
	public V getValue(UserDataContainer udc)
	{
		return (V) udc.getUserDatum(this.getKey());
	}

	/**
	 * Sets the value for a given graph/vertex/edge
	 * 
	 * @param value
	 *            the value to be stored
	 * @param udc
	 *            the graph/vertex/edge being decorated
	 */
	public void setValue(V value, UserDataContainer udc)
	{
		udc.setUserDatum(this.getKey(), value, this.getCopyAction());
	}

	/**
	 * @see edu.uci.ics.jung.graph.decorators.Decorator#getKey()
	 */
	@SuppressWarnings("unchecked")
	@Override
	public K getKey()
	{
		return (K) super.getKey();
	}
}
