/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import static com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition.DEPRECATED_ANNOTATION;
import static com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode.NODE_DEFINITION_MESSAGE_DEPRECATED;
import static com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode.NODE_DEFINITION_SUPERSTATE_DEPRECATED;
import static com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder.getInstance;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Description;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.DataCollectionManager;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;

/**
 * Validates whether a node in the graph uses a deprecated message in a resource type.
 */
public class DeprecatedNodeDefinitionRule extends ValidationRule<NodeDefinition> {

    public List<ValidationMessage> validateRule(NodeDefinition target) {
		List<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();

		if (NodeDefinitionType.SuperState.equals(target.getNodeType())) {
			Description description = target.getDescription();
			
			if (description != null) {
				String text = description.getDescription().trim().toLowerCase();
				
				if (text.indexOf(DEPRECATED_ANNOTATION) > -1) {
					getInstance().addValidationMessage(validationMessages, target, NODE_DEFINITION_SUPERSTATE_DEPRECATED);
					
					return validationMessages;
				}
			}
		} else {
	        if (NodeDefinitionType.MessageNode.equals(target.getNodeType())) {
	            NodeDefinition nodeDefinition = DataCollectionManager.getInstance().getReader().getSampleMessageNodeByUid(target.getUid());
                if (nodeDefinition != null && nodeDefinition.getDescription() != null && nodeDefinition.getDescription().getDescription().trim().toLowerCase().indexOf(DEPRECATED_ANNOTATION) > -1) {
                    getInstance().addValidationMessage(validationMessages, target, NODE_DEFINITION_MESSAGE_DEPRECATED);
	            }
	        }
		}

		return validationMessages;
	}
}