package com.tandbergtv.watchpoint.studio.debugger.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.model.elements.VariableLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.IDebugModelPresentation;

import com.tandbergtv.watchpoint.studio.debugger.launching.TemplateLauncherConstants;

public class JpdlVariableLabelProvider extends VariableLabelProvider {

    /* (non-Javadoc)
     * @see org.eclipse.debug.internal.ui.elements.adapters.VariableLabelAdapter#getValueText(org.eclipse.debug.core.model.IVariable, org.eclipse.debug.core.model.IValue)
     */
    protected String getValueText(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        IDebugModelPresentation presentation = getModelPresentation(context, TemplateLauncherConstants.ID_JPDL_DEBUG_MODEL);
        if (presentation != null) {
            return escapeSpecialChars(presentation.getText(value));
        }
        return null;
    }
}
