package com.tandbergtv.watchpoint.studio.builder.resolution.template;

import static com.tandbergtv.watchpoint.studio.ui.model.SemanticElementConstants.TEMPLATE_SEID;
import static com.tandbergtv.watchpoint.studio.ui.util.Utility.TEMPLATE_EDITOR_ID;
import static org.eclipse.ui.IWorkbenchPage.MATCH_ID;

import java.io.ByteArrayInputStream;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.builder.resolution.WatchpointStudioResolution;
import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * 		Base class for Template errors Resolution
 * 
 * @author <a href="francisco.neto@venturus.org.br">vntfrne Francisco Bento da Silva Neto</a>
 *
 */
public abstract class WatchpointStudioTemplateResolution extends WatchpointStudioResolution {
	
    protected WatchPointTemplateEditor editor = null;
	protected WorkflowTemplate template;
	protected XmlAdapter adapter;
    private boolean isOpenEditorTemplate;

    public WatchpointStudioTemplateResolution(IResource resource, Object element, Object message) {
        super(resource, element, message);
    }

	protected NodeElement getNodeElementByName(NodeElementContainer container, String name) {
		NodeElement[] nodeElements = container.getNodeElements();
		
		for (int i = 0; i < nodeElements.length; i++) {
			NodeElement e = nodeElements[i];
			if (name.equals(e.getName()))
				return e;
			
			if (e instanceof LoopNode) {
				NodeElement ee = getNodeElementByName((NodeElementContainer) e, name);
				
				if (ee != null)
					return ee;
			}
		}
		
		return null;
	}

    protected WorkflowTemplate getTemplate() throws CoreException {
        /* Check if the template is open in a template editor at the moment of the fix
         * and get the template from the editor if true  */
        WorkflowTemplate template = getTemplateFromEditor();
        isOpenEditorTemplate = true;
        
        /* If the template is not open in an editor, get the template from the file */
        if (template == null) {
            isOpenEditorTemplate = false;
            template = getClosedTemplate();
        }
        return template;
    }

    protected WorkflowTemplate getTemplateFromEditor() {
        IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        // may be null during eclipse shutdown...
        if (dwindow == null)
            return null;
    
        IWorkbenchPage page = dwindow.getActivePage();
    
        if (page == null)
            return null;
    
        IEditorReference[] editors = page.findEditors(null, TEMPLATE_EDITOR_ID, MATCH_ID);
    
        if (editors.length > 0) {
            for (int i = 0; i < editors.length; i++) {
                WatchPointTemplateEditor editor = (WatchPointTemplateEditor) editors[i]
                        .getEditor(true).getSite().getPart();
    
                FileEditorInput editorInput = (FileEditorInput) editor.getEditorInput();
    
                if (editorInput.getFile().getFullPath().toOSString()
                        .equals(getFile().getFullPath().toOSString())) {
                    this.editor = editor;
                    return editor.getProcessDefinition();
                }
            }
        }
        return null;
    }

    protected WorkflowTemplate getClosedTemplate() throws CoreException {
        if (template == null) {
            template = (WorkflowTemplate) new SemanticElementFactory(TEMPLATE_EDITOR_ID).createById(TEMPLATE_SEID);

            SemanticElementFactory factory = new SemanticElementFactory(TEMPLATE_EDITOR_ID);
            adapter = Utility.getAdapterFromStream(getFile().getName(), getFile().getContents(), factory);
            adapter.initialize(template);
        }
        return template;
    }

    protected void saveTemplate() throws CoreException {
        /* Save the template through the editor or the file according 
         * to the method the template object was obtained */
        if (isOpenEditorTemplate) {
            editor.doSave(null);
        } else {
            saveClosedTemplate();
        }
    }

    protected void saveClosedTemplate() throws CoreException {
        String xml = Utility.getXMLFromDocument(adapter.getNode().getOwnerDocument());
        
        ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes());
        getFile().setContents(input, true, false, null);
    }

    protected String calculateNewVariableName(WorkflowTemplate template, String nameRadix) {
        int i = 0;
        while (hasVariableName(template.getStartState().getTask().getController(), i == 0 ? nameRadix : nameRadix + i)) {
            i++;
        }
        return i == 0 ? nameRadix : nameRadix + i;
    }

    boolean hasVariableName(Controller controller, String variableName) {
        for (Variable variable : controller.getVariables()) {
            if (variable.getMappedName().equals(variableName)) {
                return true;
            }
        }
        return false;
    }
}