/*
 * Created on Jun 25, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dataaccess;

import java.util.List;
import java.util.Set;

import com.tandbergtv.watchpoint.studio.dto.ProtectionKey;

/**
 * The Data Access Interface for the Protection Key entity.
 * 
 * @author Vijay Silva
 */
public interface ProtectionKeyDAI extends DataAccessInterface<ProtectionKey, Long>
{
	/**
	 * Find the set of Protection Keys with matching Names.
	 * 
	 * @param names
	 *            The set of Protection Key Names
	 * 
	 * @return The set of matching Protection Keys.
	 */
	List<ProtectionKey> findByNames(Set<String> names);

	/**
	 * Find the Protection Key with a matching Name.
	 * 
	 * @param name
	 *            The Protection Key Name
	 * 
	 * @return The matching Protection Key.
	 * 
	 * @throws javax.persistence.NoResultException
	 *             If the protection key is not found
	 */
	ProtectionKey findByName(String name);
}
