/*
 * Created on Mar 20, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.external.jpf.model;

import java.util.Hashtable;
import java.util.Map;


/**
 * Entity that contains information about the Management of a Resource Type.
 * 
 * @author Vijay Silva
 */
public class ManagementDescriptor implements WatchPointDescriptor
{
	private static final long serialVersionUID = 4685402995861196929L;

	/* The Connection Type used when validating the Connection String for the Resource Type */
	private ResourceConnectionType connectionType;

	/* The Initialization Strategy Class to use, null if no strategy class specified */
	private String initializationStrategyClass;

	/* The Message UID to send when Initializing if using the default initialization */
	private Map<String, String> initializationProperties;

	/* The Heartbeat Connection Type used to validate the Heartbeat Connection String */
	private ResourceConnectionType heartbeatConnectionType;

	/* The Strategy class to use for Heartbeats */
	private String heartbeatStrategyClass;

	/* The Message UID to send when sending Heartbeat Messages */
	private Map<String, String> heartbeatProperties;

	/**
	 * @return the connectionType
	 */
	public ResourceConnectionType getConnectionType()
	{
		return this.connectionType;
	}

	/**
	 * @param connectionType
	 *            the connectionType to set
	 */
	public void setConnectionType(ResourceConnectionType connectionType)
	{
		this.connectionType = connectionType;
	}

	/**
	 * @return the heartbeatConnectionType
	 */
	public ResourceConnectionType getHeartbeatConnectionType()
	{
		return this.heartbeatConnectionType;
	}

	/**
	 * @param heartbeatConnectionType
	 *            the heartbeatConnectionType to set
	 */
	public void setHeartbeatConnectionType(ResourceConnectionType heartbeatConnectionType)
	{
		this.heartbeatConnectionType = heartbeatConnectionType;
	}

	/**
	 * @return the heartbeatProperties
	 */
	public Map<String, String> getHeartbeatProperties()
	{
		return this.heartbeatProperties;
	}

	/**
	 * @param heartbeatProperties
	 *            the heartbeatProperties to set
	 */
	public void setHeartbeatProperties(Map<String, String> heartbeatProperties)
	{
		this.heartbeatProperties = heartbeatProperties;
	}

	/**
	 * @return the heartbeatStrategyClass
	 */
	public String getHeartbeatStrategyClass()
	{
		return this.heartbeatStrategyClass;
	}

	/**
	 * @param heartbeatStrategyClass
	 *            the heartbeatStrategyClass to set
	 */
	public void setHeartbeatStrategyClass(String heartbeatStrategyClass)
	{
		this.heartbeatStrategyClass = heartbeatStrategyClass;
	}

	/**
	 * @return the initializationProperties
	 */
	public Map<String, String> getInitializationProperties()
	{
		return this.initializationProperties;
	}

	/**
	 * @param initializationProperties
	 *            the initializationProperties to set
	 */
	public void setInitializationProperties(Map<String, String> initializationProperties)
	{
		this.initializationProperties = initializationProperties;
	}

	/**
	 * @return the initializationStrategyClass
	 */
	public String getInitializationStrategyClass()
	{
		return this.initializationStrategyClass;
	}

	/**
	 * @param initializationStrategyClass
	 *            the initializationStrategyClass to set
	 */
	public void setInitializationStrategyClass(String initializationStrategyClass)
	{
		this.initializationStrategyClass = initializationStrategyClass;
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	@Override
	public Object clone()
	{
		ManagementDescriptor clone = null;

		try
		{
			clone = (ManagementDescriptor) super.clone();

			if (this.initializationProperties != null)
				clone.initializationProperties = new Hashtable<String, String>(
						this.initializationProperties);

			if (this.heartbeatProperties != null)
				clone.heartbeatProperties = new Hashtable<String, String>(this.heartbeatProperties);
		}
		catch (CloneNotSupportedException ex)
		{ // Should never happen
		}

		return clone;
	}
}
