/*
 * Created on Jul 31, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.external.wpexport;

import java.util.Map;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;

/**
 * Interface that performs the export of a WatchPoint DTO object.
 * 
 * @param <T>
 *            The Type of the object being exported
 * 
 * @author Vijay Silva
 */
public interface IWatchPointDTOExporter<T extends IWatchPointDTO>
{
	/**
	 * Export the WatchPoint DTO object
	 * 
	 * @param object
	 *            The Object to export
	 * @param exportInputs
	 *            A map of keys and object values that serve as inputs to the export process. These
	 *            inputs could include any required data such as output file name, output folder,
	 *            database connection data, etc.
	 * 
	 * @return A Map of output objects resulting from the Export. This map may be null or empty.
	 * 
	 * @throws ExportFailureException
	 *             Exception thrown if the export process fails.
	 */
	public Map<String, Object> export(T object, Map<String, Object> exportInputs)
			throws ExportFailureException;
}
