/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import java.util.List;
import java.util.StringTokenizer;

import org.dom4j.Element;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jbpm.gd.common.editor.AbstractContentProvider;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

/**
 * Content provider for the node definition editor.
 * 
 * @author Imran Naqvi
 * 
 */
public class NodeDefinitionContentProvider extends AbstractContentProvider {
	
	/**
	 * Gets the Root Semantic Element value. 
	 */
	protected String getRootSemanticInfoElement() {
		return "<nodeDefinition>";
	}

	/**
	 * @see org.jbpm.gd.common.editor.AbstractContentProvider#getNotationInfoFileName(java.lang.String)
	 */
	protected String getNotationInfoFileName(String semanticInfoFileName) {
		IPath test = new Path(semanticInfoFileName);
		test = test.removeFileExtension();
		test = test.addFileExtension("gpd");
		return test.toString();
	}

	/**
	 * @see org.jbpm.gd.common.editor.AbstractContentProvider#getSemanticInfoFileName(java.lang.String)
	 */
	protected String getSemanticInfoFileName(String notationInfoFileName) {
		if ("gpd.xml".equals(notationInfoFileName)) {
			return "nodedefinition.xml";
		}

		return super.getSemanticInfoFileName(notationInfoFileName);
	}

	/**
	 * @see org.jbpm.gd.common.editor.AbstractContentProvider#getEdgeSemanticElement(org.jbpm.gd.common.notation.Node, org.dom4j.Element, int)
	 */
	protected SemanticElement getEdgeSemanticElement(Node node, Element notationInfo, int index) {
		Transition[] transitions = ((NodeElement) node.getSemanticElement()).getTransitions();
		return index < transitions.length ? transitions[index] : null;
	}

	/**
	 * @see org.jbpm.gd.common.editor.AbstractContentProvider#getNodeSemanticElement(org.jbpm.gd.common.notation.NodeContainer, org.dom4j.Element, int)
	 */
	protected SemanticElement getNodeSemanticElement(NodeContainer nodeContainer,
			Element notationInfo, int index) {
		NodeElementContainer nodeElementContainer = (NodeElementContainer) nodeContainer.getSemanticElement();
		return nodeElementContainer.getNodeElementByName(notationInfo.attributeValue("name"));
	}
	
	/**
	 * @see org.jbpm.gd.common.editor.AbstractContentProvider#addEdges(org.jbpm.gd.common.notation.Node, org.dom4j.Element)
	 */
	@SuppressWarnings("unchecked")
	protected void addEdges(Node node, Element nodeInfo) {
		List<Element> edges = nodeInfo.elements("edge");
		for (int i = 0; i < edges.size(); i++) {
			SemanticElement edgeSemanticElement = getEdgeSemanticElement(node, edges.get(i), i);
			super.addEdge(node, edgeSemanticElement, edges.get(i));
		}
	}

	/**
	 * @see org.jbpm.gd.common.editor.AbstractContentProvider#addNodes(org.jbpm.gd.common.notation.NodeContainer, org.dom4j.Element)
	 */
	protected void addNodes(NodeContainer nodeContainer, Element notationInfo) {
		List<?> nodes = notationInfo.elements();
		for (int i = 0; i < nodes.size(); i++) {
			SemanticElement nodeSemanticElement = getNodeSemanticElement(nodeContainer, (Element)nodes.get(i), i);
			
			/* Deals with cases where the GPD has a node that is missing in the JPDL */
			if (nodeSemanticElement != null) {
				addNode(nodeContainer, nodeSemanticElement, (Element) nodes.get(i));
			}
		}
	}
	
	/**
	 * @see org.jbpm.gd.common.editor.AbstractContentProvider#findDestination(org.jbpm.gd.common.notation.Edge, org.jbpm.gd.common.notation.Node)
	 */
	protected SemanticElement findDestination(Edge edge, Node source) {
		NotationElement notationElement = source.getContainer();
		String pathCopy = ((Transition) edge.getSemanticElement()).getTo();
		while (pathCopy.length() > 3 && "../".equals(pathCopy.substring(0, 3))
				&& notationElement != null) {
			notationElement = ((Node) notationElement).getContainer();
			pathCopy = pathCopy.substring(3);
		}
		if (notationElement == null)
			return null;
		SemanticElement parent = notationElement.getSemanticElement();
		StringTokenizer tokenizer = new StringTokenizer(pathCopy, "/");
		while (parent != null && tokenizer.hasMoreTokens()) {
			if (!(parent instanceof NodeElementContainer))
				return null;
			parent = ((NodeElementContainer) parent).getNodeElementByName(tokenizer.nextToken());
		}
		return parent;
	}
}
