package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.jbpm.gd.common.editor.AbsPageEditorPart;
import org.jbpm.gd.common.editor.GraphPage;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * The graph page for the node definition editor.
 * 
 * @author Imran Naqvi
 * 
 */
public class NodeDefinitionGraphPage extends GraphPage {

	private NodeDefinitionEditor editor;

	private NodeDefinitionGraphicalViewer graphicalViewer;

	/**
	 * Ctor.
	 * 
	 * @param editor the editor to which this page belongs
	 */
	public NodeDefinitionGraphPage(NodeDefinitionEditor editor) {
		this.editor = editor;
	}

	/**
	 * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
		SashForm sashForm = new SashForm(parent, SWT.HORIZONTAL);
		NodeDefinition nodeDefinition = (NodeDefinition) this.editor.getRootContainer()
				.getSemanticElement();
		if (nodeDefinition.getNodeType() == NodeDefinitionType.SuperState) {
			addPalette(sashForm);
			addModelViewer(sashForm);
			sashForm.setWeights(new int[] { 15, 85 });
		}
		else {
			addModelViewer(sashForm);
			sashForm.setWeights(new int[] { 100 });
		}
	}
	
	/**
	 * It is a workaround for recursive Prevented recursive attempt to activate part exception
	 * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
	 */
	public void setFocus() {
		this.editor.getGraphicalViewer().getControl().setFocus(); 
	}
    
    @Override
    public ScrollingGraphicalViewer getGraphicalViewer() {
        return graphicalViewer;
    }

    @Override
    public AbsPageEditorPart getPageEditorPart() {
        return editor;
    }

	/**
	 * Gets the graphical viewer for this page.
	 * 
	 * @return the graphical viewer for this page
	 */
	public NodeDefinitionGraphicalViewer getDesignerViewer() {
		return graphicalViewer;
	}

	/**
	 * Gets the editor to which this page belongs.
	 * 
	 * @return the editor to which this page belongs
	 */
	public NodeDefinitionEditor getNodeDefinitionEditor() {
		return editor;
	}

	private void addModelViewer(Composite composite) {
		graphicalViewer = editor.createGraphicalViewer();
		graphicalViewer.initControl(composite);
		getSite().setSelectionProvider(graphicalViewer);
	}

	private void addPalette(Composite composite) {
		PaletteViewer paletteViewer = new PaletteViewer();
		paletteViewer.createControl(composite);
		editor.getEditDomain().setPaletteViewer(paletteViewer);
		editor.getEditDomain().setPaletteRoot(new NodeDefinitionPaletteRoot(editor));
	}
}
