/*
 * Created on Sep 27, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage;

import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.MessagesMasterDetailsBlock;

/**
 * The ResourceType Form Page containing the Adaptor Configuration Controls
 * 
 * @author Vijay Silva
 */
public class MessagesPage extends ResourceTypeFormPage
{
	private static final String PAGE_TITLE = "Messages";

	public static final String PAGE_ID = "ResourceType.MessagesPage";

	MessagesMasterDetailsBlock messagesBlock;

	/**
	 * @param editor
	 *            The Parent Editor
	 */
	public MessagesPage(ResourceTypeEditor editor)
	{
		super(editor, PAGE_ID, PAGE_TITLE);
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.ResourceTypeFormPage#createPageControls()
	 */
	@Override
	protected void createPageControls()
	{
		IManagedForm managedForm = this.getManagedForm();
		ScrolledForm form = managedForm.getForm();
		form.setText("Message Configuration");

		/* Create the Page Contents */
		this.messagesBlock = new MessagesMasterDetailsBlock(this);
		this.messagesBlock.createContent(managedForm);
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.ResourceTypeFormPage#initializePageLayout()
	 */
	@Override
	protected void initializePageLayout()
	{
	}
}
