package com.tandbergtv.watchpoint.studio.ui.model;

import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.Task;

import com.tandbergtv.watchpoint.studio.ui.properties.DataType;

public class AssignNode extends AbstractTaskNode {

    public WPVariable addEmptyVariable() {
        Task task = getTask();

        WPVariable variable = (WPVariable) getFactory().createById(SemanticElementConstants.VARIABLE_SEID);
        variable.setMappedName(""); 
        variable.setName("");
        variable.setType(DataType.STRING.name());
        variable.setValue("\"value\"");
        variable.setAccess("read,write");
        task.getController().addVariable(variable);
        return variable;
    }

    public void removeVariable(WPVariable variable) {
        getTask().getController().removeVariable(variable);
    }
    
    private Task getTask() {
        Task task = getTasks().length > 0 ? getTasks()[0] : null;
        if (task == null) {
            task = (Task) getFactory().createById(SemanticElementConstants.TASK_SEID);
            addTask(task);
        }

        Controller controller = task.getController();
        if (controller == null) {
            controller = (Controller) getFactory().createById(SemanticElementConstants.CONTROLLER_SEID);
            task.setController(controller);
        }
        
        return task;
    }
}