/**
 * DefaultTree.java
 * Created Apr 15, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.model.tree.provider;

import com.tandbergtv.watchpoint.studio.ui.model.tree.ITree;
import com.tandbergtv.watchpoint.studio.ui.model.tree.ITreeNode;
import com.tandbergtv.watchpoint.studio.ui.model.tree.ITreeNodeVisitor;

/**
 * A simple tree implementation
 * 
 * @author Sahil Verma
 */
public class DefaultTree<T> implements ITree<T> {

	private ITreeNode<T> root;
	
	public DefaultTree(ITreeNode<T> root) {
		this.root = root;
	}

	/**
	 * {@inheritDoc}
	 */
	public void accept(ITreeNodeVisitor<T> visitor, ITreeNode<T> node) {
		visitor.visit(node);
		
		for (ITreeNode<T> child : node.getChildren())
			accept(visitor, child);
	}

	/**
	 * {@inheritDoc}
	 */
	public ITreeNode<T> getRoot() {
		return this.root;
	}
}
