package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class ManualTaskNodeCellModifier implements ICellModifier {

    private TableViewer tableViewer;
    private String[] columnNames;

    public ManualTaskNodeCellModifier(TableViewer tableViewer, String[] columnTitles) {
        this.tableViewer = tableViewer;
        this.columnNames = columnTitles;
    }

    @Override
    public boolean canModify(Object element, String property) {
        return true;
    }

    @Override
    public Object getValue(Object element, String property) {
        WPVariable variable = (WPVariable) element;

        if (property.equals(columnNames[0])) {
            return variable.getMappedName();

        } else if (property.equals(columnNames[1])) {
            return variable.getName();

        } else if (property.equals(columnNames[2])) {
            return variable.isRequired();

        } else if (property.equals(columnNames[3])) {
            String[] wpDataTypes = Utility.toVariableTypeName(Utility.getWPDataTypes());
            String stringValue = variable.getEmptySafeType();
            int i = wpDataTypes.length - 1;
            while (i > 0 && !stringValue.equals(wpDataTypes[i])) {
                --i;
            }
            return new Integer(i);

        } else if (property.equals(columnNames[4])) {
            return variable.isReadable();

        } else if (property.equals(columnNames[5])) {
            return variable.isWritable();
        }

        return variable.getValue();
    }

    @Override
    public void modify(Object element, String property, Object value) {
        WPVariable variable = (WPVariable) ((TableItem) element).getData();

        if (property.equals(columnNames[0])) {
            variable.setMappedName((String) value);

        } else if (property.equals(columnNames[1])) {
            variable.setName((String) value);

        } else if (property.equals(columnNames[2])){
            variable.setRequired((Boolean) value);

        } else if (property.equals(columnNames[3])){
            Integer index = (Integer) value;
            String newWpType = Utility.toVariableTypeName(Utility.getWPDataTypes())[index];

            variable.setType(newWpType);

        } else if (property.equals(columnNames[4])){
            variable.setReadable((Boolean) value);

        } else if (property.equals(columnNames[5])){
            variable.setWritable((Boolean) value);

        } else if (property.equals(columnNames[6])){
            variable.setValue((String) value);
        }

        tableViewer.update(variable, new String[] { property });
    }
}
