/**
 * SimpleCommand.java
 * Created Apr 14, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.command;

import org.jbpm.gd.common.model.AbstractNamedElement;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.Logger;

import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;

/**
 * Test command
 * 
 * @author Sahil Verma
 */
public class SimpleCommand extends AbstractDiffCommand {

	/**
	 * @param name
	 * @param description
	 * @param diff
	 * @param context
	 */
	public SimpleCommand(String name, String description, IDiff diff, ISynchronizationContext context) {
		super(name, diff, context);
	}

	/**
	 * {@inheritDoc}
	 */
	public void execute() {
		String name = null;
		SemanticElement e = diff.getElement();

		if (e instanceof AbstractNamedElement)
			name = AbstractNamedElement.class.cast(e).getName();

		Logger.logInfo("Executed command for " + e.getLabel() + " name " + name + ", type " + diff.getKind());
	}
}
