package com.tandbergtv.watchpoint.studio.ui.view;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;

/**
 * Parent of the content and label providers for the validation errors tree view. This class maintains three
 * seperate lists for each type of validation error message.
 *  
 * @author Imran Naqvi
 *
 */
public class AbstractValidationProvider {

	protected List<ValidationMessage> validationErrors = new ArrayList<ValidationMessage>();
	protected List<ValidationMessage> validationWarnings = new ArrayList<ValidationMessage>();
	protected List<ValidationMessage> validationNotifications = new ArrayList<ValidationMessage>();
	protected String errorString;
	protected String warningString;
	protected String notificationString;

	/**
	 * Constructor.
	 * 
	 * @param validationMessages
	 *            The list of validation messages
	 * @param errorColumn
	 *            The name of the error column
	 * @param warningColumn
	 *            The name of the warning column
	 * @param notificationColumn
	 *            The name of the notification column
	 */
	public AbstractValidationProvider(List<ValidationMessage> validationMessages,
			String errorColumn, String warningColumn, String notificationColumn) {
		this.errorString = errorColumn;
		this.warningString = warningColumn;
		this.notificationString = notificationColumn;
		
		setInput(validationMessages);
	}
	
	/**
	 * Reset the input for this tree viewer. The three validation lists are reconstructed from the
	 * validation messages passed.
	 * 
	 * @param validationMessages
	 */
	protected void setInput(List<ValidationMessage> validationMessages){
		this.validationErrors.clear();
		this.validationWarnings.clear();
		this.validationNotifications.clear();
		
		for (ValidationMessage message : validationMessages) {
			if (message.getType() == ValidationMessageType.Error)
				validationErrors.add(message);
			else if (message.getType() == ValidationMessageType.Warning)
				validationWarnings.add(message);
			else if (message.getType() == ValidationMessageType.Notification)
				validationNotifications.add(message);
		}
	}

	/**
	 * Gets the size of the list whose label is passed.
	 * 
	 * @param listName
	 * @return The number of items for the column with the matching name
	 */
	protected int getListCount(String listName){
		if(listName.equals(this.errorString))
			return this.validationErrors.size();
		if(listName.equals(this.warningString))
			return this.validationWarnings.size();
		if(listName.equals(this.notificationString))
			return this.validationNotifications.size();
		
		return 0;
	}
}