package com.tandbergtv.watchpoint.studio.ui.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNodeType;

/**
 * Dom adapter for the loop node semantic element. <br>
 * This class is responsible for convert the model changes in XML. 
 * @author Patrik Araujo
 */
public class LoopNodeDomAdapter extends XmlAdapter {
	
	private static HashMap<String, String> NODE_TYPES = null;
	
	protected Map<String, String> getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap<String, String>();
			NODE_TYPES.put("nodeDefinition", "node-element");
			NODE_TYPES.put("auto-task", "node-element");
			NODE_TYPES.put("manual-task", "node-element");
			
			NODE_TYPES.put("description", "description");
			NODE_TYPES.put("node", "node-element");
			NODE_TYPES.put("state", "node-element");
			NODE_TYPES.put("task-node", "node-element");
			NODE_TYPES.put("super-state", "node-element");
			NODE_TYPES.put("process-state", "node-element");
			NODE_TYPES.put("fork", "node-element");
			NODE_TYPES.put("join", "node-element");
			NODE_TYPES.put("decision", "node-element");
			NODE_TYPES.put("mail-node",	"node-element");
            NODE_TYPES.put("assign", "node-element");
			NODE_TYPES.put("transition", "transition");
		}
		return NODE_TYPES;
	}

	@Override
	protected void initialize() {
		if (getSemanticElement() != null) {
			LoopNode loopNode = (LoopNode) getSemanticElement();
			setAttribute("name", loopNode.getName());
			setAttribute("list", loopNode.getListName());
			setAttribute("index", loopNode.getIndex());
			setAttribute("initialValue", Integer.toString(loopNode.getInitialValue()));
			setAttribute("expression", loopNode.getExpression());
			String typeValue = loopNode.getLoopType() != null ? loopNode.getLoopType().toString() : null;
			setAttribute("type", typeValue);
			/* Add the XML for the loop node child nodes and transitions*/
			addElements(loopNode.getNodeElements());
			addElements(loopNode.getTransitions());
		}
	}

	@Override
	public void initialize(SemanticElement jpdlElement) {
		super.initialize(jpdlElement);
		LoopNode loopNode = (LoopNode) jpdlElement;
		loopNode.setName(getAttribute("name"));
		loopNode.setListName(getAttribute("list"));
		loopNode.setIndex(getAttribute("index"));
		loopNode.setInitialValue( getAttribute("initialValue") != null ? Integer.parseInt(getAttribute("initialValue")) : 0 );
		loopNode.setExpression(getAttribute("expression"));
		LoopNodeType typeValue = getAttribute("type") != null ? LoopNodeType.valueOf(getAttribute("type").toUpperCase()) : null;
		loopNode.setLoopType(typeValue);
		
		loopNode.addPropertyChangeListener(this);
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String)evt.getNewValue());
		} else if ("list".equals(evt.getPropertyName())) {
			setAttribute("list", (String)evt.getNewValue());
		} else if ("index".equals(evt.getPropertyName())) {
			setAttribute("index", (String)evt.getNewValue());
		} else if ("initialValue".equals(evt.getPropertyName())) {
			setAttribute("initialValue", (String)evt.getNewValue());
		} else if ("expression".equals(evt.getPropertyName())) {
			setAttribute("expression", (String)evt.getNewValue());
		} else if ("type".equals(evt.getPropertyName())) {
			String typeValue = ((String)evt.getNewValue()) != null ? ((String)evt.getNewValue()).toUpperCase() : null;
			setAttribute("type", typeValue);
		}
		
		else if ("nodeElementRemove".equals(evt.getPropertyName())) {
			removeElement((SemanticElement)evt.getOldValue());
		} else if ("nodeElementAdd".equals(evt.getPropertyName())) {
			addElement((SemanticElement)evt.getNewValue());
		} else if ("transitionAdd".equals(evt.getPropertyName())) {
			addElement((Transition)evt.getNewValue());
		} else if ("transitionRemove".equals(evt.getPropertyName())) {
			removeElement((Transition)evt.getOldValue());
		}
	}

	@Override
	protected void doModelUpdate(String name, String newValue) {
		LoopNode loopNode = (LoopNode) getSemanticElement();
		if ("name".equals(name)) {
			loopNode.setName(newValue);
		} else if ("list".equals(name)) {
			loopNode.setListName(newValue);
		} else if ("index".equals(name)) {
			loopNode.setIndex(newValue);
		} else if ("initialValue".equals(name)) {
			loopNode.setInitialValue( Integer.parseInt(newValue) );
		} else if ("expression".equals(name)) {
			loopNode.setExpression(newValue);
		} else if ("type".equals(name)) {
			LoopNodeType typeValue = newValue != null ? LoopNodeType.valueOf(newValue.toUpperCase()) : null;
			loopNode.setLoopType( typeValue );
		} 
	}

	@Override
	protected void doModelAdd(XmlAdapter child) {
		String type = child.getElementType();
		SemanticElement jpdlElement = createSemanticElementFor(child);
		child.initialize(jpdlElement);
		LoopNode loopNode = (LoopNode)getSemanticElement();
		if ("transition".equals(type)) {
			loopNode.addTransition((Transition)jpdlElement);
		} else {
			loopNode.addNodeElement((NodeElement)jpdlElement);
		}
	}

	@Override
	protected void doModelRemove(XmlAdapter child) {
		String type = child.getElementType();
		LoopNode loopNode = (LoopNode) getSemanticElement();
		
		if ("transition".equals(type)) {
			loopNode.removeTransition((Transition)child.getSemanticElement());
		} else {
			loopNode.removeNodeElement( (NodeElement)child.getSemanticElement() );
		}
	}
}
