/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.xml;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;

import com.tandbergtv.watchpoint.studio.ui.model.ProtectionKey;

/**
 * The Dom Adaptor class for a protection key.
 * 
 * @author Imran Naqvi
 *
 */
public class ProtectionKeyDomAdapter extends XmlAdapter {

	private static final String NAME_ATTR = "name";

	/* (non-Javadoc)
	 * @see org.jbpm.gd.common.xml.XmlAdapter#initialize(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	public void initialize(SemanticElement jpdlElement) {
		super.initialize(jpdlElement);
		ProtectionKey protectionKey = (ProtectionKey)jpdlElement;
		protectionKey.setName(getAttribute(NAME_ATTR));
	}
	
	/* (non-Javadoc)
	 * @see org.jbpm.gd.common.xml.XmlAdapter#doModelAdd(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void doModelAdd(XmlAdapter child) {
	}

	/* (non-Javadoc)
	 * @see org.jbpm.gd.common.xml.XmlAdapter#doModelRemove(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void doModelRemove(XmlAdapter child) {
		// do nothing
	}

	/* (non-Javadoc)
	 * @see org.jbpm.gd.common.xml.XmlAdapter#doModelUpdate(java.lang.String, java.lang.String)
	 */
	@Override
	protected void doModelUpdate(String name, String newValue) {
		ProtectionKey protectionKey = (ProtectionKey)getSemanticElement();
		if (NAME_ATTR.equals(name)) {
			protectionKey.setName(newValue);
		}
	}

	/* (non-Javadoc)
	 * @see java.beans.PropertyChangeListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		if (NAME_ATTR.equals(evt.getPropertyName())) {
			setAttribute(NAME_ATTR, (String)evt.getNewValue());
		} 
	}

}
