package com.tandbergtv.watchpoint.studio.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;

/**
 * Utility class used to validate the message timeout expression . <p>
 * This validation is important to validate the timeout expression in the UI,
 * before the value be set to the object and a service method be called. <p>
 * In some cases the validation needs to be executed before a service method be called, because
 * the UI needs to response correctly to o possible input error. Even if there's a validation 
 * for timeout expression being executed by the service method. 
 * 
 * @author Patrik Araujo
 *
 */
public class TimeoutValidation {
	
	/**
	 * Validates a given timeout expression
	 * @param expression The timeout expression
	 * @return <strong>true</strong> if the timeout expression is valid. <br>
	 * <strong>false</strong> if the timeout expression is not valid.
	 */
	public static boolean isTimeoutExpressionValid(String expression){
		boolean completeFormatValid = isTimeOutFormatValid("dd'T'HH:mm:ss", expression);
		boolean partialFormatValid = isTimeOutFormatValid("HH:mm:ss", expression);
		boolean dayValid = true;
		if(completeFormatValid){
			String dayDigits = expression.substring(0, 2);
			String day = dayDigits.matches("\\d\\d") ? expression.substring(0, 2) : expression.substring(0, 1);
			if(Integer.parseInt(day) > 30){
				dayValid = false;
			}
			if(Integer.parseInt(day) == 30 && !expression.substring(3).equals("00:00:00")){
				dayValid = false;
			}
		}
		
		if( !dayValid || ( !partialFormatValid && !completeFormatValid ) ){
			return false;
		}
		
		return true;
	}
	
	
	public static boolean isTimeOutFormatValid(String pattern, String expression){
		boolean isValid = true;
		SimpleDateFormat timeOutFormat = new SimpleDateFormat(pattern);
		timeOutFormat.setLenient(false);
		try {
			timeOutFormat.parse(expression);
		} catch (ParseException e) {
			return false;
		}
		return isValid;
	}
}
