/*
 * Created on Jul 10, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation;

/**
 * An enumeration of all the Validation Message Codes.
 * 
 * @author Vijay Silva
 */
public enum ValidationMessageCode
{
	// ========================================================================
	// ===================== GEN - GENERAL VALIDATION
	// ========================================================================

	/**
	 * The General Validation Message
	 */
	GENERAL_MESSAGE("VMC-GEN-001"),

	// ========================================================================
	// ===================== GN - GRAPH NODE VALIDATION
	// ========================================================================

	/**
	 * The In-Degree of the Start Node is invalid.
	 */
	INVALID_START_NODE_IN_DEGREE("VMC-GN-001"),

	/**
	 * The In-Degree of a Node is invalid.
	 */
	INVALID_NODE_IN_DEGREE("VMC-GN-002"),

	/**
	 * The Out-Degree of the End Node is invalid.
	 */
	INVALID_END_NODE_OUT_DEGREE("VMC-GN-003"),

	/**
	 * The Out-Degree of the Decision Node is invalid.
	 */
	INVALID_DECISION_NODE_OUT_DEGREE("VMC-GN-004"),

	/**
	 * The Out-Degree of the Fork Node is invalid.
	 */
	INVALID_FORK_NODE_OUT_DEGREE("VMC-GN-005"),

	/**
	 * The Out-Degree of the Node is invalid (lower than it should be (< 1)).
	 */
	NODE_OUT_DEGREE_LOW("VMC-GN-006"),

	/**
	 * The Out-Degree of the Node is invalid (higher than it should be (> 1)).
	 */
	NODE_OUT_DEGREE_HIGH("VMC-GN-007"),

	/**
	 * The Node is not reachable from the Start Node.
	 */
	NODE_UNREACHABLE_FROM_START("VMC-GN-008"),

	/**
	 * The Node cannot reach the End Node.
	 */
	NODE_UNREACHABLE_TO_END("VMC-GN-009"),

	/**
	 * The Type of the Node is invalid.
	 */
	INVALID_NODE_TYPE("VMC-GN-010"),

	// ========================================================================
	// ===================== GFJ - GRAPH FORK JOIN NODE VALIDATION
	// ========================================================================

	/**
	 * The Fork is nested to an invalid level.
	 */
	INVALID_FORK_NEST_LEVEL("VMC-GFJ-001"),

	/**
	 * All transitions from the Fork Node do not have a paired Join node.
	 */
	FORK_MISSING_JOIN_PAIR("VMC-GFJ-002"),

	/**
	 * The Fork Node has a transition that does not reach a Join node.
	 */
	FORK_TRANSITION_MISSING_JOIN_PAIR("VMC-GFJ-003"),

	/**
	 * The Fork Node has transitions that reach more than one Join node.
	 */
	FORK_MAPPED_TO_MANY_JOINS("VMC-GFJ-004"),

	/**
	 * The Join Node is not reached by any of the Fork Nodes.
	 */
	JOIN_MISSING_FORK_PAIR("VMC-GFJ-005"),

	/**
	 * The Join Node is paired with more than one Fork node.
	 */
	JOIN_MAPPED_TO_MANY_FORKS("VMC-GFJ-006"),

	/**
	 * A Path from the Fork Node does not end at the Join node.
	 */
	FORK_PATH_MISSING_JOIN("VMC-GFJ-007"),

	/**
	 * The Fork Node can be reached by a node in the Fork Subgraph.
	 */
	FORK_REACHED_FROM_FORK_SUBGRAPH("VMC-GFJ-008"),

	/**
	 * A transition exists that directly connects the Fork to the Join.
	 */
	FORK_JOIN_PATH_EMPTY("VMC-GFJ-009"),

	/**
	 * The Join node has a transition to it that does not come from the Fork Subgraph
	 */
	JOIN_REACHED_OUTSIDE_FORK_SUBGRAPH("VMC-GFJ-010"),

	/**
	 * A node in the Fork Subgraph has a transition to it that does not come from the Fork Subgraph
	 */
	FORK_SUBGRAPH_REACHED_OUTSIDE_FORK_SUBGRAPH("VMC-GFJ-011"),

	/**
	 * The different transitions of the Fork node traverse over common / overlapping nodes
	 */
	FORK_TRANSITIONS_OVERLAP_NODES("VMC-GFJ-012"),

	// ========================================================================
	// ===================== TG - TEMPLATE GRAPH VALIDATION
	// ========================================================================

	/**
	 * The Template does not contain the required Start State Node
	 */
	TEMPLATE_MISSING_START_NODE("VMC-TG-001"),

	/**
	 * The Template contains more than one Start State Node
	 */
	TEMPLATE_EXTRA_START_NODE("VMC-TG-002"),

	/**
	 * The Template does not contain the required End State Node
	 */
	TEMPLATE_MISSING_END_NODE("VMC-TG-003"),

	/**
	 * The Template contains more than one End State Node
	 */
	TEMPLATE_EXTRA_END_NODE("VMC-TG-004"),

	/**
	 * The Template does not contain any nodes other than the Start and End State nodes
	 */
	TEMPLATE_MISSING_NODE("VMC-TG-005"),

	/**
	 * The number of fork nodes is different from the number of join nodes.
	 */
	TEMPLATE_FORK_JOIN_UNEQUAL("VMC-TG-006"),

	// ========================================================================
	// ===================== TP - TEMPLATE PROPERTY VALIDATION
	// ========================================================================

	/**
	 * The Template contains more than one node with the same name.
	 */
	TEMPLATE_NODE_NAME_NOT_UNIQUE("VMC-TP-001"),

	/**
	 * The Template contains the same protection key more than once.
	 */
	DUPLICATE_TEMPLATE_PROTECTION_KEY("VMC-TP-002"),

	/**
	 * A Node in the template uses a Resource Group who's protection key is not part of the
	 * template's protection keys.
	 */
	TEMPLATE_NODE_PROTECTION_KEY_MISMATCH("VMC-TP-003"),
	
	/**
	 * A Node in the template uses a Resource Group which is not present on workspace.
	 */
	TEMPLATE_NODE_RESOURCE_GROUP_NOT_FOUND("VMC-TP-004"),
	
	/**
	 * A Node in the template uses an invalid Resource Group.
	 */
	TEMPLATE_NODE_RESOURCE_GROUP_INVALID("VMC-TP-005"),
	
	/**
	 * A variable defined in the start-state node is not used in any Node in the template.
	 */
	TEMPLATE_START_NODE_VARIABLE_UNUSED("VMC-TP-006"),

    /**
     * A variable defined in the start-state node has an invalid name.
     */
    TEMPLATE_START_NODE_VARIABLE_NAME_INVALID("VMC-TP-007"),

    // ========================================================================
	// ===================== WTS - WORKFLOW TEMPLATE SERVICE VALIDATION
	// ========================================================================

	/**
	 * The Template name specified when creating the template is not unique in the system.
	 */
	TEMPLATE_NAME_NOT_UNIQUE("VMC-WTS-001"),

	/**
	 * The Template name specified when creating the template is null / blank.
	 */
	TEMPLATE_NAME_BLANK("VMC-WTS-002"),

	/**
	 * The Template name specified when updating the template was changed.
	 */
	TEMPLATE_NAME_CHANGED("VMC-WTS-003"),

	/**
	 * The Template Version was changed when updating the template.
	 */
	TEMPLATE_VERSION_CHANGED("VMC-WTS-004"),

	/**
	 * The Template being updated has already been marked inactive (deleted).
	 */
	TEMPLATE_SET_INACTIVE("VMC-WTS-005"),
	
	TEMPLATE_SUBPROCESS_NOT_VALID("VMC-WTS-006"),
	
	TEMPLATE_SUBPROCESS_UNMAPPED_VARIABLE("VMC-WTS-007"),
	
	TEMPLATE_SUBPROCESS_VARIABLE_MUST_BE_MAPPED_AS_READ("VMC-WTS-008"),

	TEMPLATE_SUBPROCESS_VARIABLE_NOT_DECLARED_CHILD("VMC-WTS-009"),
	
	TEMPLATE_SUBPROCESS_VARIABLE_NOT_DECLARED_PARENT("VMC-WTS-010"),
	
	TEMPLATE_SUBPROCESS_MORE_THAN_ONE_LEVEL_HIERARCHY("VMC-WTS-011"),
	
	TEMPLATE_SUBPROCESS_EXPRESSION_NOT_ALLOWED("VMC-WTS-012"),
	
	TEMPLATE_SUBPROCESS_INVALID_EXPRESSION("VMC-WTS-013"),

	// ========================================================================
	// ===================== NDG - NODE DEFINITION GRAPH VALIDATION
	// ========================================================================
	/**
	 * The Node Definition does not have a node with no incoming transitions (root node).
	 */
	NODEDEFINITION_MISSING_ROOT_NODE("VMC-NDG-001"),

	/**
	 * The Node Definition contains more than one root node (node with no incoming transitions).
	 */
	NODEDEFINITION_EXTRA_ROOT_NODE("VMC-NDG-002"),

	/**
	 * The Node Definition does not contain the required End State Node.
	 */
	NODEDEFINITION_MISSING_END_NODE("VMC-NDG-003"),

	/**
	 * The Node Definition does not contain any nodes other than the End State node(s).
	 */
	NODEDEFINITION_MISSING_NODE("VMC-NDG-004"),

	// ========================================================================
	// ===================== NDP - NODE DEFINITION PROPERTY VALIDATION
	// ========================================================================

	/**
	 * The Node Definition contains more than one node with the same name.
	 */
	NODEDEFINITION_NODE_NAME_NOT_UNIQUE("VMC-NDP-003"),

	/**
	 * The Node Definition does not have a message configured for it
	 */
	NODEDEFINITION_MESSAGE_MISSING("VMC-NDP-004"),

	/**
	 * The Super State Node Definition contains one or more variables for which the display name is
	 * blank.
	 */
	SUPERSTATE_VARIABLES_BLANK_MAPPED_NAMES("VMC-NDP-005"),

	/**
	 * One or more variables in the Super State has a name assigned, which is allowed only in a
	 * template.
	 */
	SUPERSTATE_VARIABLES_NAME_DEFINED("VMC-NDP-006"),

	/**
	 * One or more variables in the Super State have the same name assigned.
	 */
	SUPERSTATE_VARIABLES_DUPLICATE_MAPPED_NAMES("VMC-NDP-007"),
	
	EXCEPTION_HANDLER_ACTION_ARGUMENT_VALUE1("VMC-NDP-008"),
	
	EXCEPTION_HANDLER_ACTION_ARGUMENT_VALUE2("VMC-NDP-009"),

	EXCEPTION_HANDLER_ACTION_ARGUMENT_VALUE3("VMC-NDP-010"),
	
	NODE_DEFINITION_SUPERSTATE_DEPRECATED("VMC-NDP-011"),

    NODE_DEFINITION_MESSAGE_DEPRECATED("VMC-NDP-012"),
	
	// ========================================================================
	// ===================== NDS - NODE DEFINITION SERVICE VALIDATION
	// ========================================================================

	/**
	 * The Node Definition name specified is not unique in the system.
	 */
	NODEDEFINITION_NAME_NOT_UNIQUE("VMC-NDS-001"),

	/**
	 * The Node Definition name specified is null / blank.
	 */
	NODEDEFINITION_NAME_BLANK("VMC-NDS-002"),

	/**
	 * Creation of Node Definition for Out-of-the-box Resource Type is not allowed.
	 */
	NODEDEFINITION_CANNOT_CREATE_OOBRESTYPE("VMC-NDS-003"),

	/**
	 * A Single-Node Node Definition already exists that uses the same message.
	 */
	NODEDEFINITION_SAME_MESSAGE_USED("VMC-NDS-005"),
	
	/**
	 * Node Definition used by template is outdated.
	 */
	NODEDEFINITION_MESSAGE_OUTDATED("VMC-NDS-006"),
	
	/**
	 * SuperState used by template is outdated.
	 */
	NODEDEFINITION_SUPERSTATE_OUTDATED("VMC-NDS-007"),

	// ========================================================================
	// ===================== NP - NODE PROPERTY VALIDATION
	// ========================================================================

	/**
	 * The Node does not have a Resource Group configured.
	 */
	NODE_RESOURCEGROUP_UNDEFINED("VMC-NP-001"),

	/**
	 * The Node does not have a Due Date expression configured.
	 */
	NODE_DUEDATE_UNDEFINED("VMC-NP-002"),

	/**
	 * One or more of the Node's transitions does not have a label.
	 */
	NODE_TRANSITIONS_NO_LABEL("VMC-NP-005"),

	/**
	 * The Node has a blank name.
	 */
	NODE_NAME_BLANK("VMC-NP-008"),

	/**
	 * The Node contains one or more variables for which the name is blank.
	 */
	NODE_VARIABLES_BLANK_NAMES("VMC-NP-009"),

	/**
	 * The Node contains one or more variables for which the display name is blank.
	 */
	NODE_VARIABLES_BLANK_MAPPED_NAMES("VMC-NP-010"),

	/**
	 * The Node contains one or more variables with the same name.
	 */
	NODE_VARIABLES_DUPLICATE_NAMES("VMC-NP-011"),

	/**
	 * The Node contains one or more variables with the same display / mapped name.
	 */
	NODE_VARIABLES_DUPLICATE_MAPPED_NAMES("VMC-NP-012"),

	/**
	 * The Node contains one or more outgoing Transitions with duplicate Labels.
	 */
	NODE_TRANSITIONS_DUPLICATE_LABEL("VMC-NP-013"),

	/**
	 * The Decision Node does not have an expression configured either for the node, or for the
	 * outgoing transitions of the node.
	 */
	NODE_DECISION_CONFIGURATION_MISSING("VMC-NP-014"),

	/**
	 * The Decision Node has an expression configured both for the node and for the outgoing
	 * transitions of the node.
	 */
	NODE_DECISION_CONFIGURATION_DUPLICATED("VMC-NP-015"),

	/**
	 * The Decision Node has an expression configured for an outgoing transition, but not for all
	 * outgoing transitions. Parameters:
	 * <ul>
	 * <li>Decision Node Name</li>
	 * </ul>
	 */
	NODE_TRANSITION_CONDITION_MISSING("VMC-NP-016"),

	/**
	 * The Action class name defined for the node is blank.
	 */
	NODE_ACTION_CLASS_BLANK("VMC-NP-017"),

	/**
	 * The Node Definition instance inserted does not have a type assigned.
	 */
	NODE_NODE_DEFINITION_TYPE_UNDEFINED("VMC-NP-018"),
	
	/**
	 * The Node present in a Template contains a variable that is not mapped to a Template Variable.
	 * The parameters:
	 * <ul>
	 * <li>Variable Mapped Name</li>
	 * </ul>
	 */
	NODE_VARIABLE_NOT_MAPPED_IN_TEMPLATE("VMC-NP-019"),

	/**
	 * The Node present in a Node Definition contains a variable that is not mapped to a Node
	 * Definition Variable. The parameters:
	 * <ul>
	 * <li>Variable Mapped Name</li>
	 * </ul>
	 */
	NODE_VARIABLE_NOT_MAPPED_IN_NODE_DEFINITION("VMC-NP-020"),

	/**
	 * The Node Variable is mapped to a non-existing template variable. The parameters:
	 * <ul>
	 * <li>Variable Mapped Name</li>
	 * <li>Variable Name</li>
	 * </ul>
	 */
	NODE_VARIABLE_MAPPING_INVALID_IN_TEMPLATE("VMC-NP-021"),
	
	/**
	 * The Node Variable is mapped to a non-existing node definition variable. The parameters:
	 * <ul>
	 * <li>Variable Mapped Name</li>
	 * <li>Variable Name</li>
	 * </ul>
	 */
	NODE_VARIABLE_MAPPING_INVALID_IN_NODE_DEFINITION("VMC-NP-022"),

    /**
	 * The Node present in a Template contains a variable mapped to a Template variable, but the
	 * types of the variables don't match up. The parameters:
	 * <ul>
	 * <li>Variable Mapped Name</li>
	 * <li>Variable Type</li>
	 * <li>Template Variable Type</li>
	 * </ul>
	 */
	NODE_VARIABLE_TYPE_MISMATCH_IN_TEMPLATE("VMC-NP-023"),

	/**
	 * The Node present in a Super-State Node Definition contains a variable mapped to a Node
	 * Definition variable, but the types of the variables don't match up. The parameters:
	 * <ul>
	 * <li>Variable Mapped Name</li>
	 * <li>Variable Type</li>
	 * <li>Node Definition Variable Type</li>
	 * </ul>
	 */
	NODE_VARIABLE_TYPE_MISMATCH_IN_NODE_DEFINITION("VMC-NP-024"),

	/**
	 * The Node has a Resource Group configured when it is not allowed.
	 */
	NODE_RESOURCEGROUP_DEFINED("VMC-NP-025"),

	/**
	 * The Node has a Due Date expression configured when it is not allowed.
	 */
	NODE_DUEDATE_DEFINED("VMC-NP-026"),

	/**
	 * The Node contains action arguments / variables that have blank names.
	 */
	NODE_ACTION_VARIABLES_BLANK_NAMES("VMC-NP-029"),

	/**
	 * The Node contains action arguments / variables that have duplicate names. The Parameters:
	 * <ul>
	 * <li>Action Variable Name</li>
	 * </ul>
	 */
	NODE_ACTION_VARIABLES_DUPLICATE_NAMES("VMC-NP-030"),

	/**
	 * The Node contains more than one transition to another Node.
	 * <ul>
	 * <li>Target/Destination Node Name</li>
	 * <li>The number of parallel transitions</li>
	 * </ul>
	 */
	NODE_TRANSITIONS_PARALLEL("VMC-NP-031"),
	
	/**
	 * The Rollback Node present in a Template contains a variable that is not mapped to a Template Variable.
	 * The parameters:
	 * <ul>
	 * <li>Variable Mapped Name</li>
	 * </ul>
	 */
	ROLLBACK_VARIABLE_NOT_MAPPED_IN_TEMPLATE("VMC-NP-032"),

	/**
	 * The Node Rollback Variable is mapped to a non-existing template variable. The parameters:
	 * <ul>
	 * <li>Variable Mapped Name</li>
	 * <li>Variable Name</li>
	 * </ul>
	 */
	ROLLBACK_VARIABLE_MAPPING_INVALID_IN_TEMPLATE("VMC-NP-033"),

	/**
	 * The Rollback Node present in a Template contains a variable mapped to a Template variable, but the
	 * types of the variables don't match up. The parameters:
	 * <ul>
	 * <li>Variable Mapped Name</li>
	 * <li>Variable Type</li>
	 * <li>Template Variable Type</li>
	 * </ul>
	 */
	ROLLBACK_VARIABLE_TYPE_MISMATCH_IN_TEMPLATE("VMC-NP-034"),
	
	/**
	 * The Node Definition instance inserted does not have a Resource Type present on workspace.
	 */
	NODE_DEFINITION_TYPE_NOT_FOUND("VMC-NP-035"),
	
	/**
	 * The Node Definition instance inserted is owned by a Resource Type that has errors.
	 */
	NODE_DEFINITION_TYPE_IS_INVALID("VMC-NP-036"),
	
	/**
	 * The Node Definition Message inserted does not exists on the Resource Type anymore.
	 */
	NODE_DEFINITION_MESSAGE_NOT_FOUND("VMC-NP-037"),
	
	/**
	 * The SuperState inserted does not exists on the Resource Type anymore.
	 */
	SUPERSTATE_NOT_FOUND("VMC-NP-038"),
	
	/**
	 * Node name has invalid characters
	 */
	NODE_NAME_INVALID("VMC-NP-039"),
	
	/**
	 * The Node Variable is mapped to an invalid script.
	 * <ul>
	 * <li>Variable Mapped Name</li>
	 * <li>Variable Name</li>
	 * </ul>
	 */
	NODE_VARIABLE_MAPPING_INVALID_SCRIPT("VMC-NP-040"),
	
	/**
	 * The Node has no variables.
	 */
	NODE_MISSING_VARIABLES("VMC-NP-041"),

    /**
     * The Node Variable is mapped to a non-existing template variable. The parameters:
     * <ul>
     * <li>Variable Mapped Name</li>
     * <li>Variable Name</li>
     * </ul>
     */
    NODE_VARIABLE_MAPPING_INVALID_IN_ASSIGN_NODE("VMC-NP-042"),

	// ========================================================================
	// ===================== NV - NODE VARIABLE VALIDATION
	// ========================================================================

	/**
	 * The Variable in the Node Element has a blank Name. The Parameters:
	 * <ul>
	 * <li>Variable Name</li>
	 * <li>Variable Mapped Name</li>
	 * </ul>
	 */
	VARIABLE_NAME_BLANK("VMC-NV-001"),

	/**
	 * The Variable in the Node Element has a non-blank Name with an invalid value. The Parameters:
	 * <ul>
	 * <li>Variable Name</li>
	 * <li>Variable Mapped Name</li>
	 * </ul>
	 */
	VARIABLE_NAME_INVALID("VMC-NV-002"),

	/**
	 * The Variable in the Node Element has a blank Mapped Name. The Parameters:
	 * <ul>
	 * <li>Variable Name</li>
	 * <li>Variable Mapped Name</li>
	 * </ul>
	 */
	VARIABLE_MAPPED_NAME_BLANK("VMC-NV-003"),

	/**
	 * The Variable in the Node Element has a non-blank Mapped Name with an invalid value. The
	 * Parameters:
	 * <ul>
	 * <li>Variable Name</li>
	 * <li>Variable Mapped Name</li>
	 * </ul>
	 */
	VARIABLE_MAPPED_NAME_INVALID("VMC-NV-004"),

	/**
	 * The Variable in the Node Element has a blank Type. The Parameters:
	 * <ul>
	 * <li>Variable Name</li>
	 * <li>Variable Mapped Name</li>
	 * </ul>
	 */
	VARIABLE_TYPE_BLANK("VMC-NV-005"),

	/**
	 * The Variable in the Node Element has a non-blank Type with invalid value. The Parameters:
	 * <ul>
	 * <li>Variable Name</li>
	 * <li>Variable Mapped Name</li>
	 * </ul>
	 */
	VARIABLE_TYPE_INVALID("VMC-NV-006"),

	/**
	 * The Variable in the Super State has a non-blank Mapped Name with an invalid value. The
	 * Parameters:
	 * <ul>
	 * <li>Variable Name</li>
	 * <li>Variable Mapped Name</li>
	 * </ul>
	 */
	VARIABLE_MAPPED_NAME_INVALID_IN_SUPERSTATE("VMC-NV-007"),

	/**
	 * The Variable in the Super State has a blank Type. The Parameters:
	 * <ul>
	 * <li>Variable Name</li>
	 * <li>Variable Mapped Name</li>
	 * </ul>
	 */
	VARIABLE_TYPE_BLANK_IN_SUPERSTATE("VMC-NV-008"),

	/**
	 * The Variable in the Super State has a non-blank Type with invalid value. The Parameters:
	 * <ul>
	 * <li>Variable Name</li>
	 * <li>Variable Mapped Name</li>
	 * </ul>
	 */
	VARIABLE_TYPE_INVALID_IN_SUPERSTATE("VMC-NV-009"),
	
	/**
	 * Value does not match the data type
	 */
	VARIABLE_VALUE_INVALID("VMC-NV-015"),

	/**
	 * Access permissions are incorrect
	 */
	VARIABLE_ACCESS_INVALID("VMC-NV-016"),
	
	/**
	 * The Variable attached to the Action Element has a blank Name.
	 */
	ACTION_VARIABLE_NAME_BLANK("VMC-NV-010"),

	/**
	 * The Variable attached to the Action Element has an Invalid Name. The invalid name is the only
	 * parameter.
	 */
	ACTION_VARIABLE_NAME_INVALID("VMC-NV-011"),

	/**
	 * The Variable attached to the Action Element has a blank value when the value is required. The
	 * Parameters:
	 * <ul>
	 * <li>Variable Name</li>
	 * </ul>
	 */
	ACTION_VARIABLE_VALUE_BLANK("VMC-NV-012"),

	/**
	 * The Variable attached to the Action Element has a value that is not an positive integer
	 * (greater than 0). The Parameters:
	 * <ul>
	 * <li>Variable Name</li>
	 * </ul>
	 */
	ACTION_VARIABLE_VALUE_NOT_POSITIVE_INTEGER("VMC-NV-013"),

	/**
	 * The Variable attached to the Action Element has a Name that is not allowed. The name is the only
	 * parameter.
	 */
	ACTION_VARIABLE_NAME_NOT_ALLOWED("VMC-NV-014"),

	// ========================================================================
	// ===================== TRN - TRANSITION VALIDATION
	// ========================================================================

	/**
	 * The Transition contains a Condition and does not begin from a Decision Node.
	 */
	TRANSITION_CONDITION_NOT_FROM_DECISION("VMC-TRN-001"),

	// ========================================================================
	// ===================== RTS - RESOURCE TYPE SERVICE VALIDATION
	// ========================================================================

	/**
	 * The ResourceType name specified during creation is null / blank.
	 */
	RESOURCE_TYPE_NAME_BLANK("VMC-RTS-001"),

	/**
	 * The ResourceType name specified during creation is not unique in the system.
	 */
	RESOURCE_TYPE_NAME_NOT_UNIQUE("VMC-RTS-002"),

	/**
	 * The ResourceType System Id is null / blank.
	 */
	RESOURCE_TYPE_SYSTEM_ID_BLANK("VMC-RTS-003"),

	/**
	 * The ResourceType System Id is not unique in the system.
	 */
	RESOURCE_TYPE_SYSTEM_ID_NOT_UNIQUE("VMC-RTS-004"),

	/**
	 * The ResourceType System Id does not match the expected format (2 alphanumeric characters).
	 */
	RESOURCE_TYPE_SYSTEM_ID_INVALID("VMC-RTS-005"),

	/**
	 * The ResourceType Connection Type is null / blank.
	 */
	RESOURCE_TYPE_CONNECTION_TYPE_BLANK("VMC-RTS-006"),

	/**
	 * The ResourceType Adaptor Type is null / blank.
	 */
	RESOURCE_TYPE_ADAPTOR_TYPE_BLANK("VMC-RTS-007"),

	/**
	 * The ResourceType adaptor class name for the custom adaptor is null / blank.
	 */
	RESOURCE_TYPE_CUSTOM_ADAPTOR_CLASSNAME_BLANK("VMC-RTS-008"),

	/**
	 * The ResourceType HeartBeat Connection Type is null when heart beats are required.
	 */
	RESOURCE_TYPE_HEARTBEAT_CONNECTION_TYPE_BLANK("VMC-RTS-010"),

	/**
	 * The ResourceType HeartBeat Strategy Class is null/blank when heart beats are required.
	 */
	RESOURCE_TYPE_HEARTBEAT_STRATEGY_BLANK("VMC-RTS-011"),

	/**
	 * The ResourceType Initialization Strategy Class is null/blank when initialization is required.
	 */
	RESOURCE_TYPE_INITIALIZATION_STRATEGY_BLANK("VMC-RTS-012"),

	/**
	 * The ResourceType Message Name is null/blank.
	 */
	RESOURCE_TYPE_MESSAGE_NAME_BLANK("VMC-RTS-013"),

	/**
	 * The ResourceType Message UID is blank.
	 */
	RESOURCE_TYPE_MESSAGE_UID_BLANK("VMC-RTS-014"),

	/**
	 * The ResourceType Message UID is invalid (does not match the expected format).
	 */
	RESOURCE_TYPE_MESSAGE_UID_INVALID("VMC-RTS-015"),

	/**
	 * The ResourceType Message UID Source System Id doesn't match the Resource Type System Id.
	 */
	INCOMING_MESSAGE_UID_SOURCE_INVALID("VMC-RTS-016"),

	/**
	 * The ResourceType Message UID Destination System Id doesn't match the WFS System Id.
	 */
	INCOMING_MESSAGE_UID_DESTINATION_INVALID("VMC-RTS-017"),

	/**
	 * The ResourceType Message UID Source System Id doesn't match the WFS System Id.
	 */
	OUTGOING_MESSAGE_UID_SOURCE_INVALID("VMC-RTS-018"),

	/**
	 * The ResourceType Message UID Destination System Id doesn't match the Resource Type System Id.
	 */
	OUTGOING_MESSAGE_UID_DESTINATION_INVALID("VMC-RTS-019"),

	/**
	 * The Resource Type contains messages that share the same UID.
	 */
	RESOURCE_TYPE_UID_DUPLICATES_ERROR("VMC-RTS-020"),

	/**
	 * The Resource Type system Id has been changed during an update.
	 */
	RESOURCE_TYPE_SYSTEM_ID_CHANGED("VMC-RTS-022"),

	/**
	 * An existing Message UID for a Resource Type has been changed during an update.
	 */
	MESSAGE_UID_CHANGED("VMC-RTS-023"),

	/**
	 * The direction (incoming / outgoing) of an existing Message for a Resource Type has been
	 * changed during an update.
	 */
	MESSAGE_DIRECTION_CHANGED("VMC-RTS-024"),

	/**
	 * The Adaptor Type specified is 'None' when there are messages present.
	 */
	RESOURCE_TYPE_ADAPTOR_TYPE_INVALID("VMC-RTS-025"),

	/**
	 * The Resource Type Default Protocol is null or blank.
	 */
	RESOURCE_TYPE_DEFAULT_PROTOCOL_BLANK("VMC-RTS-026"),

	/**
	 * The name used by a message is not unique for a particular Resource Type
	 */
	RESOURCE_TYPE_MESSAGE_NAME_DUPLICATES_ERROR("VMC-RTS-027"),

	/**
	 * The Resource Type contained in the Message is null
	 */
	RESOURCE_TYPE_MESSAGE_RESOURCE_TYPE_NULL("VMC-RTS-028"),

	/**
	 * The Resource Type set for the Message is different from the Resource Type containing the
	 * Message
	 */
	RESOURCE_TYPE_MESSAGE_RESOURCE_TYPE_INVALID("VMC-RTS-029"),

	/**
	 * The Name of a Message being created for a Resource Type is not unique.
	 */
	RESOURCE_TYPE_MESSAGE_NAME_NOT_UNIQUE("VMC-RTS-030"),

	/**
	 * The UID of a Message being created is not unique.
	 */
	RESOURCE_TYPE_MESSAGE_UID_NOT_UNIQUE("VMC-RTS-031"),

	/**
	 * Creation of out-of-the-box Resource Type is not allowed.
	 */
	RESOURCE_TYPE_CANNOT_CREATE_OOB("VMC-RTS-032"),

	/**
	 * The Resource Type Name has too many characters
	 */
	RESOURCE_TYPE_NAME_TOO_LONG("VMC-RTS-033"),

	/**
	 * The Resource Type Initialization Strategy has too many characters
	 */
	RESOURCE_TYPE_INITIALIZATION_STRATEGY_TOO_LONG("VMC-RTS-035"),

	/**
	 * The Resource Type Heartbeat Strategy has too many characters
	 */
	RESOURCE_TYPE_HEARTBEAT_STRATEGY_TOO_LONG("VMC-RTS-036"),

	/**
	 * The Resource Type Message name has too many characters
	 */
	RESOURCE_TYPE_MESSAGE_NAME_TOO_LONG("VMC-RTS-037"),

	/**
	 * The Resource Type Message protocol has too many characters
	 */
	RESOURCE_TYPE_MESSAGE_PROTOCOL_TOO_LONG("VMC-RTS-038"),

	/**
	 * The Resource Type custom adaptor class name has too many characters
	 */
	RESOURCE_TYPE_CUSTOM_ADAPTOR_CLASSNAME_TOO_LONG("VMC-RTS-040"),

	/**
	 * The Resource Type message identifier class name has too many characters
	 */
	RESOURCE_TYPE_MESSAGE_IDENTIFIER_TOO_LONG("VMC-RTS-041"),

	/**
	 * The Resource Type has adaptor defined, but does not have messages.
	 */
	RESOURCE_TYPE_CANNOT_EXPORT_NO_MESSAGES("VMC-RTS-042"),

	// ========================================================================
	// ===================== RG - RESOURCE GROUP VALIDATION
	// ========================================================================

	/**
	 * The Resource Group name is not unique in the system.
	 */
	RESOURCEGROUP_NAME_NOT_UNIQUE("VMC-RG-001"),

	/**
	 * The Resource Group name is null / blank.
	 */
	RESOURCEGROUP_NAME_BLANK("VMC-RG-002"),

	/**
	 * The Resource Group name is changed.
	 */
	RESOURCEGROUP_NAME_CHANGED("VMC-RG-003"),

	/**
	 * The specified Resource Type does not exist in the database.
	 */
	RESOURCEGROUP_RESOURCETYPE_NOTEXISTS("VMC-RG-004"),

	/**
	 * The Resource Type is changed.
	 */
	RESOURCEGROUP_RESOURCETYPE_CHANGED("VMC-RG-005"),

	/**
	 * The Resource Type is null or ID is not set
	 */
	RESOURCEGROUP_RESOURCETYPE_NOTSET("VMC-RG-006"),

	/**
	 * The Protection Key is null / blank
	 */
	RESOURCEGROUP_PROTKEY_BLANK("VMC-RG-007"),

	/**
	 * The Resource Group cannot be deleted as it was exported
	 */
	RESOURCEGROUP_CANTDEL_EXPORTED("VMC-RG-008"),

	/**
	 * The Resource Group cannot be deleted as it is being used by workflow template(s)
	 */
	RESOURCEGROUP_CANTDEL_USEDBYTEMPLATE("VMC-RG-009"),

	/**
	 * The Resource Group Name should not be more than 50 characters length
	 */
	RESOURCEGROUP_NAME_TOO_LARGE("VMC-RG-010"),

	/**
	 * The Resource Group Functional Type should not be more than 256 characters length
	 */
	RESOURCEGROUP_FUNTYPE_TOO_LARGE("VMC-RG-011"),

	/**
	 * The Resource Group Allocation Strategy should not be more than 256 characters length
	 */
	RESOURCEGROUP_ALLOCSTRAT_TOO_LARGE("VMC-RG-012"),

	/**
	 * The Resource Group Image File Name should not be more than 150 characters length
	 */
	RESOURCEGROUP_IMAGEFILENAME_TOO_LARGE("VMC-RG-013"),

	/**
	 * The Resource Group Protection Key Name should not be more than 50 characters length
	 */
	RESOURCEGROUP_PROTKEY_TOO_LARGE("VMC-RG-014"),
	
	/**
	 * Resource Type not found
	 */
	RESOURCEGROUP_RESOURCETYPE_NOT_FOUND("VMC-RG-015"),
	
	/**
	 * Resource Type is invalid
	 */
	RESOURCEGROUP_RESOURCETYPE_INVALID("VMC-RG-016"),

	// ========================================================================
	// ===================== MN - MAIL NODE VALIDATION
	// ========================================================================
	/**
	 * Mail node destination field is blank
	 */
	MAILNODE_DESTINATION_BLANK("VMC-MN-001"),
	
	/**
	 * Mail node destination field is too large
	 */
	MAILNODE_DESTINATION_TOO_LARGE("VMC-MN-002"),
	
	/**
	 * Mail node subject field is too large
	 */
	MAILNODE_SUBJECT_TOO_LARGE("VMC-MN-003"),

	/**
	 * Mail node attachment field is too large
	 */
	MAILNODE_ATTACHMENT_TOO_LARGE("VMC-MN-004"),

	/**
	 * Mail node body field is too large
	 */
	MAILNODE_BODY_TOO_LARGE("VMC-MN-005"),

	
	// ========================================================================
	// ===================== LN - LOOP NODE VALIDATION
	// ========================================================================
	/**
	 * Loop Node has no child (Internal node)
	 */
	LOOPNODE_NO_CHILD("VMC-LN-001"),
	
	/**
	 * Loop Node index is not the type Integer 
	 */
	LOOPNODE_INDEX_WRONG_TYPE("VMC-LN-002"),
	
	/**
	 * Loop Node list is not the type LIST 
	 */
	LOOPNODE_LIST_WRONG_TYPE("VMC-LN-003"),
	
	/**
	 * Loop Node list is not the type LIST (Internal node)
	 */
	LOOPNODE_MORE_THAN_ONE_ROOT("VMC-LN-004"),
	
	/**
	 * Loop Node list is not the type LIST (Internal node)
	 */
	LOOPNODE_INDEX_VARIABLE_MODIFIED("VMC-LN-005"),
	
	/**
	 * Loop Node boolean expression is invalid
	 */
	LOOPNODE_INVALID_EXPRESSION("VMC-LN-006"),
	
	/**
	 * Loop Node boolean expression is invalid
	 */
	LOOPNODE_MISSING_INDEX_VARIABLE("VMC-LN-007"),
	
	/**
	 * Loop Node boolean expression is invalid
	 */
	LOOPNODE_MISSING_LIST_VARIABLE("VMC-LN-008"),
	
	// ========================================================================
	// ===================== TE - TIMER EXPRESSION VALIDATION
	// ========================================================================

	/**
	 * Invalid Due Date Expression.(01T00:10:20,00:10:20+00:20:40,00:10:20*10)
	 */
	DUEDATE_INVALID_TIMER_EXPRESSION("VMC-TE-001"),

	/**
	 * Due Date field operand must be a variable of type Duration or a constant in a valid Duration
	 * format.(01T00:10:20,00:10:20)
	 */
	DUEDATE_INVALID_DURATION_FORMAT("VMC-TE-003"),

	/**
	 * Both the operands of Due Date field should be either variables of type Duration or constant
	 * in a valid Duration format.(00:10:20+00:20:40)
	 */
	DUEDATE_OPERANDS_TYPE_DURATION("VMC-TE-004"),

	/**
	 * First operand of Due Date field should be a variable of type Duration or constant in a valid
	 * Duration format and the other must be a variable of type Integer/String or a
	 * constant(00:10:20*10)
	 */
	DUEDATE_OPERAND_TYPE_DURATION_INTEGER("VMC-TE-005"),

	// ========================================================================
	// ===================== DE - DECISION EXPRESSION VALIDATION
	// ========================================================================

	INVALID_DECISION_EXPRESSION("VMC-DE-001"),

	INVALID_BRACKETS("VMC-DE-002"),

	INVALID_QUOTES("VMC-DE-003"),

	ILLEGAL_CHARACTERS("VMC-DE-004"),

	INVALID_VARIABLES("VMC-DE-005"),

	INVALID_NUMBER_OF_VARIABLES("VMC-DE-006"),

	INVALID_TRANSITION_VARIABLES("VMC-DE-007"),

	INVALID_OPEN_CLOSE_PARENTHESIS("VMC-DE-008"),

	INVALID_TRANSITION_QUOTES("VMC-DE-009"),

	INVALID_DECISION_TRANSITION("VMC-DE-010"),

	INVALID_TRANSITION_EXTRA_QUOTES("VMC-DE-012"),

	TRANSITION_VARIABLE_EMPTY("VMC-DE-013"),

	/**
	 * Message code if the format of the transition expression is invalid
	 */
	INVALID_CONDITION_EXPRESSION("VMC-DE-014"),

	
	// ========================================================================
	// ===================== PP - PREFERENCE PAGES VALIDATION
	// ========================================================================
	
	INVALID_DEPLOYMENT_KEY("VMC-PP-001");
	
	// ========================================================================
	// ===================== END ENUMERATIONS
	// ========================================================================

	// The Message Code
	private String code;

	/*
	 * Constructor
	 */
	ValidationMessageCode(String code)
	{
		this.code = code;
	}

	/**
	 * Get the Code associated with this validation message code.
	 * 
	 * @return The Code string value
	 */
	public String getCode()
	{
		return this.code;
	}
}
