package com.tandbergtv.watchpoint.studio.validation.impl;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;

import com.tandbergtv.watchpoint.studio.ui.WatchPointStudioPlugin;
import com.tandbergtv.watchpoint.studio.ui.preferences.PreferencesMessages;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;

public class ValidationMessageCodeAndTypeMapper {
    private Map<ValidationMessageCode, ValidationMessageType> map = new HashMap<ValidationMessageCode, ValidationMessageType>();
    private IPreferenceStore store = WatchPointStudioPlugin.getDefault().getPreferenceStore();
    
    private static ValidationMessageCodeAndTypeMapper instance;
    
    public static synchronized ValidationMessageCodeAndTypeMapper getInstance() {
        if (instance == null) {
            instance = new ValidationMessageCodeAndTypeMapper();
        } else {
            instance.updateMap();
        }
        return instance;
    }

    private ValidationMessageCodeAndTypeMapper() {
        updateMap();
    }

    private void updateMap() {
        map.clear();
        String preferenceKey = null;
        String validationLevel = null;
        for (ValidationMessageCode validationCode : ValidationMessageCode.class.getEnumConstants()) {
            preferenceKey = new StringBuilder().append(PreferencesMessages.PREFERENCE_PREFIX)
                    .append(validationCode.getCode().replace("-", "_"))
                    .append(PreferencesMessages.PREFERENCE_SUFFIX).toString();
            if (store.getString(preferenceKey) != null && !store.getString(preferenceKey).trim().isEmpty()) {
                validationLevel = store.getString(preferenceKey);
                if (validationLevel.equals(JavaCore.ERROR)) {
                    map.put(validationCode, ValidationMessageType.Error);

                } else if (validationLevel.equals(JavaCore.WARNING)) {
                    map.put(validationCode, ValidationMessageType.Warning);

                }
            }
        }
    }

    public ValidationMessageType map(ValidationMessageCode code) {
        return map.get(code);
    }
}