package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.loopnode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.jbpm.gd.jpdl.model.NodeElement;

import com.tandbergtv.watchpoint.studio.ui.model.IWPVariableContainer;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

public class LoopNodeIndexValueRule extends ValidationRule<LoopNode>{

	@Override
	public List<ValidationMessage> validateRule(LoopNode target) {
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
		
		String indexVariable = target.getIndex();
		List<NodeElement> nodeElements = Arrays.asList(target.getNodeElements());
		for (NodeElement nodeElement : nodeElements) {
			if(nodeElement instanceof IWPVariableContainer){
				IWPVariableContainer variableContainer = (IWPVariableContainer) nodeElement;
				for (WPVariable variable : variableContainer.getVariables()) {
					if( indexVariable != null && indexVariable.equals(variable.getName()) ){
						if (variable.isWritable()){
						    ValidationMessageAdder.getInstance().addValidationMessage(messages, target, ValidationMessageCode.LOOPNODE_INDEX_VARIABLE_MODIFIED);
						}
					}
				}
			}
		}
		return messages;
	}
}
