/*
 * Created on Nov 12, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.manualtasknode;

import static com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode.VARIABLE_VALUE_INVALID;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.ui.model.ManualTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesRule;

/**
 * Validates all the variables in the Manual TaskNode, ensuring that the required fields are
 * present.
 * 
 * @author Vijay Silva
 */
public class VariablesRule extends NodeVariablesRule<ManualTaskNode>
{
	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesRule#getVariables(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected List<Variable> getVariables(ManualTaskNode node)
	{
		List<Variable> variables = new ArrayList<Variable>();

		List<WPVariable> nodeVariables = node.getVariables();
		if (nodeVariables != null)
			variables.addAll(nodeVariables);

		return variables;
	}

	/**
	 * Does not validate if the node contains a group of variables with blank names.
	 * 
	 * @return false
	 * 
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesRule#isValidatingBlankNames(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected boolean isValidatingBlankNames(ManualTaskNode node)
	{
		return false;
	}

	/**
	 * Does not validate each variable for a blank name.
	 * 
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesRule#isValidatingNameBlank(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected boolean isValidatingNameBlank(ManualTaskNode node)
	{
		return false;
	}

	/**
	 * Do not validate the value of the name since it is mapped to an existing variable name.
	 * 
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesRule#isValidatingNameValue(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected boolean isValidatingNameValue(ManualTaskNode node)
	{
		return false;
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesRule#isValidatingMappedNameBlank(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected boolean isValidatingMappedNameBlank(ManualTaskNode node)
	{
		return false;
	}
	
	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesRule#validateValue(org.jbpm.gd.jpdl.model.NodeElement, org.jbpm.gd.jpdl.model.Variable, java.util.List<ValidationMessage>)
	 */
	protected void validateValue(ManualTaskNode node, Variable variable, List<ValidationMessage> messages)
	{
		WPVariable v = WPVariable.class.cast(variable);
		DataType datatype = DataType.STRING;
		
		if (v.getType() != null)
			datatype = DataType.valueOf(v.getType());
		
		String value = v.getValue();
		
		/* It's optional... */
		if (value == null || value.trim().length() == 0)
			return;
		
		String[] values = value.split(",");
		
		for (String singleValue : values) {
			if (!datatype.match(singleValue)) {
				List<String> parameters = new ArrayList<String>();
	
				parameters.add((variable.getName() != null) ? variable.getName() : "");
				parameters.add(singleValue);
				ValidationMessageAdder.getInstance().addValidationMessage(messages, node, VARIABLE_VALUE_INVALID, parameters);
			}
		}
	}
}
