/*
 * Created on Nov 9, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.manualtasknode;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.ui.model.ManualTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesUniqueRule;

/**
 * Rule to validate that all variables in the Manual TaskNode have a unique 'Display Name'
 * 
 * @author Vijay Silva
 */
public class VariablesUniqueRule extends NodeVariablesUniqueRule<ManualTaskNode>
{
	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesUniqueRule#getVariables(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected List<Variable> getVariables(ManualTaskNode node)
	{
		List<Variable> variables = new ArrayList<Variable>();

		List<WPVariable> nodeVariables = node.getVariables();
		if (nodeVariables != null)
			variables.addAll(nodeVariables);

		return variables;
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesUniqueRule#isValidatingUniqueName(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected boolean isValidatingUniqueName(ManualTaskNode node)
	{
		return false;
	}
}
