/*
 * Created on Nov 9, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.startstate;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesUniqueRule;

/**
 * Validate that all the Variables in the Start State have a unique process variable name and a
 * unique display name.
 * 
 * @author Vijay Silva
 */
public class VariablesUniqueRule extends NodeVariablesUniqueRule<StartState>
{
	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesUniqueRule#getVariables(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected List<Variable> getVariables(StartState node)
	{
		List<Variable> variables = new ArrayList<Variable>();

		Task task = node.getTask();
		Controller controller = (task != null) ? task.getController() : null;
		Variable[] nodeVariables = (controller != null) ? controller.getVariables() : null;
		if (nodeVariables != null)
			for (Variable variable : nodeVariables)
				variables.add(variable);

		return variables;
	}
}
