/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.rules.upgradde;

import com.ericsson.rules.upgradde.UpgraddeActionParameters;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class UpgraddeRules {
    public static final String PROGRAM_SHORT_NAME = "CMS Rules Action Parameter Upgrade";
    private static final String PROGRAM_VERSION_NUMBER = "1.5";
    private static final String DEFAULT_USERNAME = "wfs";
    private static final String DEFAULT_PASSWORD = "Wf$1234";
    private static final String DEFAULT_SID = "ttv";
    private static final String DEFAULT_SERVER = "localhost";

    public static void main(String[] args) {
        GnuParser parser = new GnuParser();
        Options options = UpgraddeRules.createOptions();
        String userName = null;
        String password = null;
        String sid = null;
        String serverURL = null;
        boolean force = false;
        boolean badInputs = false;
        try {
            CommandLine commandLine = parser.parse(options, args);
            if (commandLine.hasOption("version")) {
                System.out.println("CMS Rules Action Parameter Upgrade : 1.5");
                return;
            }
            userName = commandLine.getOptionValue("username");
            password = commandLine.getOptionValue("password");
            serverURL = commandLine.getOptionValue("serverName");
            sid = commandLine.getOptionValue("sid");
            if (userName == null) {
                userName = DEFAULT_USERNAME;
            }
            if (password == null) {
                password = DEFAULT_PASSWORD;
            }
            if (serverURL == null) {
                serverURL = DEFAULT_SERVER;
            }
            if (sid == null) {
                sid = DEFAULT_SID;
            }
            if (commandLine.hasOption("force")) {
                force = true;
            }
            if (!badInputs) {
                UpgraddeActionParameters upgradde = new UpgraddeActionParameters(serverURL, sid, userName, password);
                try {
                    upgradde.upgrade(force);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(PROGRAM_SHORT_NAME, options);
            }
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        Option optionHelp = new Option("help", "print this message");
        Option optionVersion = new Option("version", "print the version information and exist");
        OptionBuilder.withArgName((String)"serverName");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Server Host Name, e.g., localhost");
        Option optionServerURL = OptionBuilder.create((String)"serverName");
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"User Name");
        Option optionUserName = OptionBuilder.create((String)"username");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Password");
        Option optionPassword = OptionBuilder.create((String)"password");
        OptionBuilder.withArgName((String)"sid");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Oracle SID");
        Option optionSid = OptionBuilder.create((String)"sid");
        Option force = new Option("force", "disregard version in database and force change.");
        options.addOption(optionHelp);
        options.addOption(optionVersion);
        options.addOption(optionServerURL);
        options.addOption(optionUserName);
        options.addOption(optionPassword);
        options.addOption(optionSid);
        options.addOption(force);
        return options;
    }
}

