#!/bin/sh

DB_INSTALL_LOG=cmsdbinstall.log
INSTALL_DIR=`pwd`
MYHOST=`hostname`

# check this script should run only for oracle user.
if [ `whoami` !=  "oracle" ]; then
  echo "**************************************************************"
  echo " You can run this script as an oracle user only,"
  echo " Please try again as an oracle user....!"
  echo "**************************************************************"
  exit 1
fi

if ! grep -q "LD_LIBRARY_PATH" "/home/oracle/.bash_profile"
then
   echo "Adding LD_LIBRARY_PATH env variable in /home/oracle/.bash_profile file"
   echo "export LD_LIBRARY_PATH=$ORACLE_HOME/lib:$ORACLE_HOME/lib32">> /home/oracle/.bash_profile
fi;

if [ -z "$ORACLE_SID" ];
then
	echo "Exporting environment variable ORACLE_SID=ttv"
	export ORACLE_SID=ttv
fi

sqlplus -S /nolog<<EOF1
conn / as sysdba
set termout off
set head off
set feed off
set trimspool on
spool oracletext.txt
select comp_name||' '||status from dba_registry where comp_name='Oracle Text' and status='VALID';
EOF1

if [ `grep -c 'Oracle Text VALID' oracletext.txt` = 0 ]; then
echo "......Installing Oracle Text please wait......"
sqlplus -S /nolog <<EOF2
conn / as SYSDBA
set termout off
SET VERIFY OFF
set echo off
spool context.log append
@/opt/oracle/product/11.2.0/db_1/ctx/admin/catnoctx;
@/opt/oracle/product/11.2.0/db_1/ctx/admin/catctx n2bbsys SYSAUX TEMP NOLOCK;
connect "CTXSYS"/"n2bbsys"
@/opt/oracle/product/11.2.0/db_1/ctx/admin/defaults/dr0defin.sql "AMERICAN";
spool off
EOF2
fi

rm -f oracletext.txt

sh ${INSTALL_DIR}/rulesUpgrade.sh -serverName ${MYHOST} -sid ${ORACLE_SID} -username wfs -password Wf\$1234 2>&1 | tee ${INSTALL_DIR}/${DB_INSTALL_LOG}

sh ${INSTALL_DIR}/masterCMS.sh ${INSTALL_DIR} 2>&1 | tee ${INSTALL_DIR}/${DB_INSTALL_LOG}

echo "*********************************************************"
if [ ! -f ${INSTALL_DIR}/${DB_INSTALL_LOG} ] 
then
     echo "CMS DB Install script probably failed!  ${INSTALL_DIR}/${DB_INSTALL_LOG} file is not exists..!"
     echo "*********************************************************"
     exit 1
else

     echo "*********************************************************"
     if  grep -q "ORA-\|SP2-\|Permission denied\|SQL-" "${INSTALL_DIR}/${DB_INSTALL_LOG}" 
     then
	echo "CMS DB Install script probably failed! Check ${INSTALL_DIR}/${DB_INSTALL_LOG} file for any errors"
        echo "*********************************************************"
	exit 1
     else
	echo "DB INSTALL SCRIPT SUCCEEDED!"
     fi
fi
     echo "*********************************************************"
     exit 0
