#!/bin/sh
##############################################################
# Name of the file : ptitles.sh                              #
##############################################################
# Description : Script to purge the CMS(v1.5) Titles         #
# Parameters  : 1) Number of titles to be deleted            # 
#               2) Title Retention Margin in days            #
#                                                            #
# Created by  : Suresh Neravati                              #
# Version #   : 1.0                                          #
# Date        : 10/19/2011                                   #
#                                                            #
##############################################################
ORA_SID="ttv"
TITLES_TOBE_DELETED=$1
TITLE_RETENSION_MARGIN=$2
PDIR="/home/oracle/scripts/cms"
# only oracle user can run this script.
if [ `whoami` !=  "oracle" ]; then
  echo "**************************************************************"
  echo " You can run this script as an oracle user only,"
  echo " Please try again as an oracle user....!"
  echo "**************************************************************"
  exit 1
fi
if [ "X${TITLES_TOBE_DELETED}" = "X" ] || [ "X${TITLE_RETENSION_MARGIN}" = "X" ]; 
then
  echo "Run the script with right parameters"
  exit 1
fi
if ! [[ "${TITLES_TOBE_DELETED}" =~ ^[0-9]+$ ]] ; then
  echo "Parameter-1 is not a number"; 
  exit 1
fi
if ! [[ "${TITLE_RETENSION_MARGIN}" =~ ^[0-9]+$ ]] ; then
  echo "Parameter-2 is not a number"; 
  exit 1
fi

echo "*******************************************************"
echo "**** Script started at $(date) "
echo "*******************************************************"
export ORACLE_SID=${ORA_SID}
export ORACLE_BASE=/opt/oracle
export ORACLE_HOME=/opt/oracle/product/11.2.0/db_1
/opt/oracle/product/11.2.0/db_1/bin/sqlplus -s /nolog @${PDIR}/purge_cms_titles.sql
/opt/oracle/product/11.2.0/db_1/bin/sqlplus -s /nolog @${PDIR}/purge_error_log_script.sql
/opt/oracle/product/11.2.0/db_1/bin/sqlplus -s /nolog <<EOF
connect / as sysdba
set feedback off
grant create any table to wfs;
conn wfs/Wf\$1234
set serveroutput on
set feedback off
spool "${PDIR}/purge_titles.log" append
BEGIN
   dbms_output.put_line(chr(10)||'Title purge started at '||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss'||chr(10)));
   wfs.PURGE_CMS_TITLES.PURGE_TITLE_OLDDATA(${TITLES_TOBE_DELETED},${TITLE_RETENSION_MARGIN});
   dbms_output.put_line(chr(10)||'Title purge ended at '||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss'||chr(10)));
END;
/
spool off
EOF
echo "*******************************************************"
echo "**** Script ended at $(date) "
echo "*******************************************************"
exit 0 

