connect / as sysdba
set feedback off
grant create any table to wfs;
conn wfs/Wf$1234
set feedback off
set echo off

create or replace package PURGE_CMS_TITLES as
  PROCEDURE createobject(vsql varchar2,errmsg varchar2 default NULL, mask varchar2 default 'N');
  PROCEDURE purge_title_olddata(titles_tobe_deleted IN NUMBER, title_retension_margin IN NUMBER);
  procedure enable_disable_const(p_table_name in varchar2, p_enable_disable in varchar2, p_mask_msg varchar2 default 'N');
  FUNCTION append_zeros(wk_release VARCHAR2) RETURN VARCHAR2;
  vsql varchar2(32767);
END;
/
CREATE OR REPLACE PACKAGE BODY PURGE_CMS_TITLES AS
/* Procedure: CreateObject. Executes a dynamic SQL statement and logs error in purge_log table */
  PROCEDURE CREATEOBJECT(vsql varchar2,errmsg varchar2 default NULL, mask varchar2 default 'N') IS
    verrmsg varchar2(32000);
  BEGIN
    EXECUTE IMMEDIATE VSQL;
  EXCEPTION
    WHEN OTHERS THEN
          verrmsg := substr(errmsg ||' '||sqlerrm,1,4000);
      IF UPPER(MASK) != 'Y' THEN
          EXECUTE IMMEDIATE 'INSERT INTO purge_log values('''||REPLACE(verrmsg,'''')||''','''||SYSDATE||''')';
          RAISE;
      END IF;
  END createobject;

  PROCEDURE insert_log_message(vsql varchar2, mask_msg varchar2 default 'N') IS
    verrmsg varchar2(32000);
  BEGIN
    createobject('INSERT INTO purge_log (Message, recordTime) VALUES('''||vsql||''',systimestamp)','*** Error in '||vsql, mask_msg);
    dbms_output.put_line(vsql);
  EXCEPTION
    WHEN OTHERS THEN
          verrmsg := substr(vsql ||' '||sqlerrm,1,4000);
      IF UPPER(mask_msg) != 'Y' THEN
          EXECUTE IMMEDIATE 'INSERT INTO purge_log values('''||REPLACE(verrmsg,'''')||''','''||SYSDATE||''')';
          RAISE;
      END IF;
  END insert_log_message; 

  PROCEDURE enable_disable_const(p_table_name IN VARCHAR2, p_enable_disable IN VARCHAR2, p_mask_msg VARCHAR2 DEFAULT 'N') IS    
    enable_disable varchar2(50);
    MSG_STR varchar2(100);
    
  BEGIN
    IF UPPER(P_ENABLE_DISABLE)='E' THEN
      enable_disable:= 'ENABLE NOVALIDATE';
      msg_str := 'Enabled constraints';
    ELSIF UPPER(P_ENABLE_DISABLE)='D' THEN
      enable_disable:= 'DISABLE';
      msg_str := 'Disabled constraints';
    END IF;

    FOR c_const_rec IN (SELECT 'ALTER TABLE '||owner||'.'||table_name||' '||enable_disable||' CONSTRAINT '||constraint_name AS CONST_STR
                          FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE='R' AND R_CONSTRAINT_NAME IN (SELECT CONSTRAINT_NAME FROM USER_CONSTRAINTS
                         WHERE constraint_type='P' AND table_name=''||upper(p_table_name)||'') UNION ALL
                        SELECT 'ALTER TABLE '||OWNER||'.'||TABLE_NAME||' '||ENABLE_DISABLE||' CONSTRAINT '||CONSTRAINT_NAME
                          FROM user_constraints WHERE constraint_type='R' AND table_name=''||upper(p_table_name)||'') 
    LOOP
         createobject(C_CONST_REC.CONST_STR,C_CONST_REC.CONST_STR,p_mask_msg);
    END LOOP;
    --INSERT_LOG_MESSAGE(MSG_STR||'on '||p_table_name);
  END;

  FUNCTION append_zeros(wk_release VARCHAR2) RETURN VARCHAR2 AS
   prev NUMBER:=0;
   vstr VARCHAR2(200);
   vout VARCHAR2(200);
  BEGIN
  --wk_release:='3.2.12.15.7.3';
    FOR i IN (select a.rnum from (select rownum rnum, substr( wk_release,level,1 ) item
            FROM DUAL CONNECT BY LEVEL < LENGTH(wk_release)+1) A WHERE item ='.')
    LOOP
      select trim(to_char(substr(wk_release,prev+1,(i.rnum-prev)-1),'00')) into vstr from dual;
      vout:=vout||'.'||vstr;
      prev:=i.rnum;
    end loop;
    vout:=substr(vout||'.'||trim(to_char(substr(wk_release,prev+1),'00')),2);
    RETURN VOUT;  
  END append_zeros;
  
  PROCEDURE purge_title_olddata(titles_tobe_deleted IN NUMBER, title_retension_margin IN NUMBER) IS
		wk_message	VARCHAR2(500);
		err_msg		  VARCHAR2(500);
    v_highdtinterval DATE;
    wk_release  VARCHAR2(30);
  BEGIN  
    IF ((TITLES_TOBE_DELETED > 0) AND (TITLE_RETENSION_MARGIN > 0 )) THEN    
      dbms_output.put_line(' '); 

      EXECUTE IMMEDIATE 'SELECT setting_value
                           FROM WFS.SYSTEM_SETTINGS
                          WHERE setting_type = ''RELEASE'''
                   INTO wk_release;
        
     IF (append_zeros(WK_RELEASE) BETWEEN '03.01.00' AND '03.02.04') THEN -- For CMS 1.5 
      dbms_output.put_line('At CMS 1.5 purge code ');
      -- Drop the purge_log
       vsql:='DROP TABLE purge_log';
      createobject(vsql,'DROP TABLE purge_log','Y');
  
      -- Create purge_log table
      vsql:='CREATE TABLE purge_log(Message varchar2(4000), recordTime timestamp default systimestamp)';
      createobject(VSQL,'CREATE TABLE purge_log');
  
      vsql:='INSERT INTO purge_log (Message, recordTime) VALUES(''Script started'',systimestamp)';
      CREATEOBJECT(VSQL,'INSERT INTO purge_log');   

      -- Drop and recreate the table tmp_purge_title to store all delete candidate records
      vsql:='Drop table tmp_purge_title';
      createobject(VSQL,'DROP tmp_purge_title','Y');

      VSQL:='CREATE TABLE tmp_purge_title(title_id, originaltitle_id, asset_id,  PRIMARY KEY(title_id,asset_id)) 
       ORGANIZATION INDEX 
       NOLOGGING
       AS SELECT t.id_, t.originaltitle_id, t.asset_id 
              FROM pmm_title t
              WHERE t.titlestatusid=5 
              START WITH (t.titlestatusid=5 AND t.updatedate < (sysdate-'||title_retension_margin||') AND t.originaltitle_id IS NULL)
              CONNECT BY  t.originaltitle_id = PRIOR t.id_
              ORDER SIBLINGS BY t.id_';
      createobject(VSQL,'CREATE TABLE tmp_purge_title','Y');

      VSQL:='Drop table tmp_purge_title_master';
      createobject(VSQL,'DROP tmp_purge_title_master','Y');      
      
      VSQL:='CREATE TABLE tmp_purge_title_master(title_id, originaltitle_id, asset_id,  PRIMARY KEY(title_id,asset_id)) 
               ORGANIZATION INDEX 
               NOLOGGING
               AS SELECT title_id, originaltitle_id, asset_id 
                    FROM (SELECT title_id, originaltitle_id, asset_id FROM tmp_purge_title WHERE rownum<='||titles_tobe_deleted||') 
                   WHERE originaltitle_id IS NULL';  
      createobject(VSQL,'CREATE TABLE tmp_purge_title_master','Y');
      
      VSQL:='Drop table tmp_purging_titles';
      createobject(VSQL,'DROP tmp_purging_titles','Y');      
      
      VSQL:='CREATE TABLE tmp_purging_titles(title_id, originaltitle_id, asset_id,  PRIMARY KEY(title_id,asset_id)) 
               ORGANIZATION INDEX 
               NOLOGGING
               AS SELECT id_, originaltitle_id, asset_id FROM pmm_title 
                   WHERE originaltitle_id IN (SELECT title_id FROM tmp_purge_title_master) union all
                   select title_id, originaltitle_id, asset_id from tmp_purge_title_master';  
      CREATEOBJECT(VSQL,'CREATE TABLE tmp_purging_titles','Y');
     
      VSQL:='begin DBMS_STATS.GATHER_TABLE_STATS (OWNNAME=>''WFS'',TABNAME=>''TMP_PURGING_TITLES'',force=>true); end;';
      createobject(VSQL,'Gather stats for TMP_PURGE_TITLE_CHILD','Y');
      
      VSQL:='begin DBMS_STATS.GATHER_TABLE_STATS (OWNNAME=>''WFS'',TABNAME=>''TMP_PURGE_TITLE_MASTER'',force=>true); end;';
      CREATEOBJECT(VSQL,'Gather stats for TMP_PURGE_TITLE_MASTER','Y');

        enable_disable_const('CMS_ASSETLIST_ASSET_METADATA','D','Y');
        vsql := 'DELETE FROM cms_assetlist_asset_metadata WHERE assetlist_assetmap_id IN (SELECT id FROM cms_assetlist_asset_map WHERE title_id IN (SELECT title_id FROM tmp_purging_titles))';
                 --LOG ERRORS INTO cms_assetlist_asset_metadataEL ('||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||') REJECT LIMIT '||titles_tobe_deleted;
        createobject(vsql,'delete cms_assetlist_asset_metadata');
        insert_log_message('deleted cms_assetlist_asset_metadata');
        enable_disable_const('CMS_ASSETLIST_ASSET_METADATA','E','Y');
        
        enable_disable_const('CMS_ASSETLIST_ASSET_MAP','D','Y');
        vsql := 'DELETE FROM cms_assetlist_asset_map WHERE title_id IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO wfs.CMS_ASSETLIST_ASSET_MAPEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete cms_assetlist_asset_map');
        insert_log_message('deleted cms_assetlist_asset_map');
        enable_disable_const('CMS_ASSETLIST_ASSET_MAP','E','Y');
        
        enable_disable_const('SITES_TRACKSITETITLE','D','Y');        
        vsql := 'DELETE FROM sites_tracksitetitle WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO sites_tracksitetitleEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete sites_tracksitetitle');
        insert_log_message('deleted sites_tracksitetitle');
        enable_disable_const('SITES_TRACKSITETITLE','E','Y');
        
        enable_disable_const('SITES_DISTSITETITLE','D','Y');
        vsql := 'DELETE FROM sites_distsitetitle WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO sites_distsitetitleEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete sites_distsitetitle');
        insert_log_message('deleted sites_distsitetitle');
        enable_disable_const('SITES_DISTSITETITLE','E','Y');
  
        enable_disable_const('PMM_PROPERTIES','D','Y');
        vsql := 'DELETE FROM pmm_properties WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO pmm_propertiesEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete pmm_properties');
        insert_log_message('deleted pmm_properties');
        enable_disable_const('PMM_PROPERTIES','E','Y');
  
        enable_disable_const('PMM_PROGRESSITEM','D','Y');
        vsql := 'DELETE FROM pmm_progressitem WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO pmm_progressitemEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete pmm_progressitem');
        insert_log_message('deleted pmm_progressitem');
        enable_disable_const('PMM_PROGRESSITEM','E','Y');
        
        enable_disable_const('PMM_TITLE_TITLELISTXREF','D','Y');
        vsql := 'DELETE FROM pmm_title_titlelistxref WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO pmm_title_titlelistxrefEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete pmm_title_titlelistxref');
        insert_log_message('deleted pmm_title_titlelistxref');
        enable_disable_const('PMM_TITLE_TITLELISTXREF','E','Y');
  
        enable_disable_const('PMM_TITLEASSET_PROPERTY','D','Y');
        vsql := 'DELETE FROM pmm_titleasset_property WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO pmm_titleasset_propertyEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete pmm_titleasset_property');
        insert_log_message('deleted pmm_titleasset_property');
        enable_disable_const('PMM_TITLEASSET_PROPERTY','E','Y');
  
        enable_disable_const('PMM_TITLEASSETSTATUS','D','Y');
        vsql := 'DELETE FROM pmm_titleassetstatus WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO pmm_titleassetstatusEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete pmm_titleassetstatus');
        insert_log_message('deleted pmm_titleassetstatus');
        enable_disable_const('PMM_TITLEASSETSTATUS','E','Y');
  
        enable_disable_const('PMM_TITLE_PURGE_HISTORY','D','Y');
        vsql := 'DELETE FROM pmm_title_purge_history WHERE title_id IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO pmm_title_purge_historyEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        CREATEOBJECT(VSQL,'delete pmm_title_purge_history');
        insert_log_message('deleted pmm_title_purge_history');
        enable_disable_const('PMM_TITLE_PURGE_HISTORY','E','Y');
  
        enable_disable_const('PMM_TITLE','D','Y');
        vsql := 'DELETE FROM pmm_title WHERE id_ IN (SELECT title_id FROM tmp_purging_titles) 
                 LOG ERRORS INTO pmm_titleEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED'; 
        createobject(vsql,'delete pmm_title');
        --vsql := 'DELETE FROM pmm_title WHERE id_ IN (SELECT title_id FROM tmp_purging_titles) and originaltitle_id is null LOG ERRORS INTO pmm_titleEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED'; 
        --createobject(vsql,'delete pmm_title');
        insert_log_message('deleted pmm_title');
        enable_disable_const('PMM_TITLE','E','Y');
 
        enable_disable_const('MDM_FIELD','D','Y');
        vsql := 'DELETE FROM mdm_field WHERE rootasset_id IN (SELECT asset_id FROM tmp_purging_titles)';
        createobject(vsql,'delete mdm_field');
        insert_log_message('deleted mdm_field'); 
        enable_disable_const('MDM_FIELD','E','Y');
        
        enable_disable_const('MDM_FIELDREVISION','D','Y');
        vsql := 'DELETE FROM mdm_fieldrevision WHERE rootasset_id IN (SELECT asset_id FROM tmp_purging_titles)';
        createobject(vsql,'delete mdm_fieldrevision');
        insert_log_message('deleted mdm_fieldrevision');  
        enable_disable_const('MDM_FIELDREVISION','E','Y');
  
        enable_disable_const('MDM_ROOTASSETREVISION','D','Y');
        vsql := 'DELETE FROM mdm_rootassetrevision WHERE asset_id IN (SELECT asset_id FROM tmp_purging_titles)
                 LOG ERRORS INTO mdm_rootassetrevisionEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete mdm_rootassetrevision');
        insert_log_message('deleted mdm_rootassetrevision');  
        enable_disable_const('MDM_ROOTASSETREVISION','E','Y');
  
        enable_disable_const('MDM_RELATION','D','Y');
        vsql := 'DELETE FROM mdm_relation WHERE owning_asset_id IN (SELECT id FROM mdm_asset WHERE rootasset_id IN (SELECT asset_id FROM tmp_purging_titles)) '||
                'OR target_asset_id IN (SELECT id FROM mdm_asset WHERE rootasset_id IN (SELECT asset_id FROM tmp_purging_titles))
                 LOG ERRORS INTO mdm_relationEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete mdm_relation');
        insert_log_message('deleted mdm_relation');
        enable_disable_const('MDM_RELATION','E','Y');
  
        enable_disable_const('MDM_ASSET','D','Y');
        vsql := 'DELETE FROM mdm_asset WHERE rootasset_id IN (SELECT asset_id FROM tmp_purging_titles) 
                 LOG ERRORS INTO mdm_assetEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED'; 
        createobject(vsql,'delete mdm_asset on rootassetid');        
        vsql := 'DELETE FROM mdm_asset WHERE id IN (SELECT asset_id FROM tmp_purging_titles) 
                 LOG ERRORS INTO mdm_assetEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED'; 
        createobject(vsql,'delete mdm_asset on id');
        insert_log_message('deleted mdm_asset');  
        enable_disable_const('MDM_ASSET','E','Y');
        COMMIT;
        
     ELSE  -- For CMS2.0 onwards
     
        DBMS_OUTPUT.PUT_LINE('At CMS 2.0 purge code '); 
        -- Drop the purge_log
        vsql:='DROP TABLE purge_log';
        createobject(vsql,'DROP TABLE purge_log','Y');
  
        -- Create purge_log table
        vsql:='CREATE TABLE purge_log(Message varchar2(4000), recordTime timestamp default systimestamp)';
        createobject(vsql,'CREATE TABLE purge_log');
  
        VSQL:='INSERT INTO purge_log (Message, recordTime) VALUES(''Script started'',systimestamp)';
        createobject(vsql,'INSERT INTO purge_log');   

        -- Drop and recreate the table tmp_purge_title to store all delete candidate records
        vsql:='Drop table tmp_purge_title';
        createobject(vsql,'DROP tmp_purge_title','Y');

        vsql:='CREATE TABLE tmp_purge_title(title_id, originaltitle_id, asset_id,  PRIMARY KEY(title_id)) 
                ORGANIZATION INDEX 
                NOLOGGING
                 AS SELECT t.id_, t.originaltitle_id, t.asset_id 
                      FROM pmm_title t
                     WHERE t.titlestatusid=5 
                     START WITH (t.titlestatusid=5 AND t.updatedate < (sysdate-'||title_retension_margin||') AND t.originaltitle_id IS NULL)
                   CONNECT BY  t.originaltitle_id = PRIOR t.id_
                     ORDER SIBLINGS BY t.id_';
        createobject(vsql,'CREATE TABLE tmp_purge_title','Y');

        vsql:='Drop table tmp_purge_title_master';
        createobject(vsql,'DROP tmp_purge_title_master','Y');      
      
        vsql:='CREATE TABLE tmp_purge_title_master(title_id, originaltitle_id, asset_id,  PRIMARY KEY(title_id)) 
               ORGANIZATION INDEX 
               NOLOGGING
               AS SELECT title_id, originaltitle_id, asset_id 
                    FROM (SELECT title_id, originaltitle_id, asset_id FROM tmp_purge_title WHERE rownum<='||titles_tobe_deleted||') 
                   WHERE originaltitle_id IS NULL';  
        createobject(vsql,'CREATE TABLE tmp_purge_title_master','Y');
      
        vsql:='Drop table tmp_purging_titles';
        createobject(vsql,'DROP tmp_purging_titles','Y');      
      
        vsql:='CREATE TABLE tmp_purging_titles(title_id, originaltitle_id, asset_id,  PRIMARY KEY(title_id)) 
               ORGANIZATION INDEX 
               NOLOGGING
               AS SELECT id_, originaltitle_id, asset_id FROM pmm_title 
                   WHERE originaltitle_id IN (SELECT title_id FROM tmp_purge_title_master) union all
                   select title_id, originaltitle_id, asset_id from tmp_purge_title_master';  
        createobject(vsql,'CREATE TABLE tmp_purging_titles','Y');
     
        vsql:='begin DBMS_STATS.GATHER_TABLE_STATS (OWNNAME=>''WFS'',TABNAME=>''TMP_PURGING_TITLES'',force=>true); end;';
        createobject(vsql,'Gather stats for TMP_PURGE_TITLE_CHILD','Y');
      
        vsql:='begin DBMS_STATS.GATHER_TABLE_STATS (OWNNAME=>''WFS'',TABNAME=>''TMP_PURGE_TITLE_MASTER'',force=>true); end;';
        createobject(vsql,'Gather stats for TMP_PURGE_TITLE_MASTER','Y');


        enable_disable_const('CMS_ASSETLIST_ASSET_METADATA','D','Y');
        vsql := 'DELETE FROM cms_assetlist_asset_metadata WHERE assetlist_assetmap_id IN (SELECT id FROM cms_assetlist_asset_map WHERE title_id IN (SELECT title_id FROM tmp_purging_titles))';
                 --LOG ERRORS INTO cms_assetlist_asset_metadataEL ('||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||') REJECT LIMIT '||titles_tobe_deleted;
        createobject(vsql,'delete cms_assetlist_asset_metadata');
        insert_log_message('deleted cms_assetlist_asset_metadata');
        enable_disable_const('CMS_ASSETLIST_ASSET_METADATA','E','Y');
        
        enable_disable_const('CMS_ASSETLIST_ASSET_MAP','D','Y');
        vsql := 'DELETE FROM cms_assetlist_asset_map WHERE title_id IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO wfs.CMS_ASSETLIST_ASSET_MAPEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete cms_assetlist_asset_map');
        insert_log_message('deleted cms_assetlist_asset_map');
        enable_disable_const('CMS_ASSETLIST_ASSET_MAP','E','Y');
        
        enable_disable_const('SITES_TRACKSITETITLE','D','Y');        
        vsql := 'DELETE FROM sites_tracksitetitle WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO sites_tracksitetitleEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete sites_tracksitetitle');
        insert_log_message('deleted sites_tracksitetitle');
        enable_disable_const('SITES_TRACKSITETITLE','E','Y');
        
        enable_disable_const('SITES_DISTSITETITLE','D','Y');
        vsql := 'DELETE FROM sites_distsitetitle WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO sites_distsitetitleEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete sites_distsitetitle');
        insert_log_message('deleted sites_distsitetitle');
        enable_disable_const('SITES_DISTSITETITLE','E','Y');
  
        enable_disable_const('PMM_PROPERTIES','D','Y');
        vsql := 'DELETE FROM pmm_properties WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO pmm_propertiesEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete pmm_properties');
        insert_log_message('deleted pmm_properties');
        enable_disable_const('PMM_PROPERTIES','E','Y');
  
        enable_disable_const('PMM_PROGRESSITEM','D','Y');
        vsql := 'DELETE FROM pmm_progressitem WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO pmm_progressitemEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete pmm_progressitem');
        insert_log_message('deleted pmm_progressitem');
        enable_disable_const('PMM_PROGRESSITEM','E','Y');
        
        enable_disable_const('PMM_TITLE_TITLELISTXREF','D','Y');
        vsql := 'DELETE FROM pmm_title_titlelistxref WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO pmm_title_titlelistxrefEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete pmm_title_titlelistxref');
        insert_log_message('deleted pmm_title_titlelistxref');
        enable_disable_const('PMM_TITLE_TITLELISTXREF','E','Y');
  
        enable_disable_const('PMM_TITLEASSET_PROPERTY','D','Y');
        vsql := 'DELETE FROM pmm_titleasset_property WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO pmm_titleasset_propertyEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete pmm_titleasset_property');
        insert_log_message('deleted pmm_titleasset_property');
        enable_disable_const('PMM_TITLEASSET_PROPERTY','E','Y');
  
        enable_disable_const('PMM_TITLEASSETSTATUS','D','Y');
        vsql := 'DELETE FROM pmm_titleassetstatus WHERE titleid IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO pmm_titleassetstatusEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete pmm_titleassetstatus');
        insert_log_message('deleted pmm_titleassetstatus');
        enable_disable_const('PMM_TITLEASSETSTATUS','E','Y');
  
        enable_disable_const('PMM_TITLE_PURGE_HISTORY','D','Y');
        vsql := 'DELETE FROM pmm_title_purge_history WHERE title_id IN (SELECT title_id FROM tmp_purging_titles)
                 LOG ERRORS INTO pmm_title_purge_historyEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        CREATEOBJECT(VSQL,'delete pmm_title_purge_history');
        insert_log_message('deleted pmm_title_purge_history');
        enable_disable_const('PMM_TITLE_PURGE_HISTORY','E','Y');

        vsql := 'DELETE FROM wfs.mdm_metadata WHERE extractvalue(sys_nc_rowinfo$,''/ECMFSpec/@documentId'') '||
                'IN (SELECT mdmdocid FROM wfs.pmm_title where id_ IN (SELECT title_id FROM tmp_purging_titles))';
        createobject(vsql,'delete mdm_metadata');
        insert_log_message('deleted mdm_metadata');

        vsql := 'DELETE FROM wfs.mdm_metadata_revision WHERE extractvalue(sys_nc_rowinfo$,''/ECMFSpec/@documentId'') '||
                'IN (SELECT mdmdocid FROM wfs.pmm_title where id_ IN (SELECT title_id FROM tmp_purging_titles))';
        createobject(vsql,'delete mdm_metadata_revision');
        insert_log_message('deleted mdm_metadata_revision');

        enable_disable_const('PMM_TITLE','D','Y');
        vsql := 'DELETE FROM pmm_title WHERE id_ IN (SELECT title_id FROM tmp_purging_titles) 
                 LOG ERRORS INTO pmm_titleEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED'; 
        createobject(vsql,'delete pmm_title');
        insert_log_message('deleted pmm_title');
        ENABLE_DISABLE_CONST('PMM_TITLE','E','Y');
/* 
        enable_disable_const('MDM_FIELD','D','Y');
        vsql := 'DELETE FROM mdm_field WHERE rootasset_id IN (SELECT asset_id FROM tmp_purging_titles)';
        createobject(vsql,'delete mdm_field');
        insert_log_message('deleted mdm_field'); 
        enable_disable_const('MDM_FIELD','E','Y');
        
        enable_disable_const('MDM_FIELDREVISION','D','Y');
        vsql := 'DELETE FROM mdm_fieldrevision WHERE rootasset_id IN (SELECT asset_id FROM tmp_purging_titles)';
        createobject(vsql,'delete mdm_fieldrevision');
        insert_log_message('deleted mdm_fieldrevision');  
        enable_disable_const('MDM_FIELDREVISION','E','Y');
  
        enable_disable_const('MDM_ROOTASSETREVISION','D','Y');
        vsql := 'DELETE FROM mdm_rootassetrevision WHERE asset_id IN (SELECT asset_id FROM tmp_purging_titles)
                 LOG ERRORS INTO mdm_rootassetrevisionEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete mdm_rootassetrevision');
        insert_log_message('deleted mdm_rootassetrevision');  
        enable_disable_const('MDM_ROOTASSETREVISION','E','Y');
  
        enable_disable_const('MDM_RELATION','D','Y');
        vsql := 'DELETE FROM mdm_relation WHERE owning_asset_id IN (SELECT id FROM mdm_asset WHERE rootasset_id IN (SELECT asset_id FROM tmp_purging_titles)) '||
                'OR target_asset_id IN (SELECT id FROM mdm_asset WHERE rootasset_id IN (SELECT asset_id FROM tmp_purging_titles))
                 LOG ERRORS INTO mdm_relationEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED';
        createobject(vsql,'delete mdm_relation');
        insert_log_message('deleted mdm_relation');
        enable_disable_const('MDM_RELATION','E','Y');
  
        enable_disable_const('MDM_ASSET','D','Y');
        vsql := 'DELETE FROM mdm_asset WHERE rootasset_id IN (SELECT asset_id FROM tmp_purging_titles) 
                 LOG ERRORS INTO mdm_assetEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED'; 
        createobject(vsql,'delete mdm_asset on rootassetid');        
        vsql := 'DELETE FROM mdm_asset WHERE id IN (SELECT asset_id FROM tmp_purging_titles) 
                 LOG ERRORS INTO mdm_assetEL ('''||to_char(sysdate,'mm/dd/yyyy hh24:mi:ss')||''') REJECT LIMIT UNLIMITED'; 
        createobject(vsql,'delete mdm_asset on id');
        insert_log_message('deleted mdm_asset');  
        enable_disable_const('MDM_ASSET','E','Y');
*/
        
        COMMIT;
     END IF;
     INSERT_LOG_MESSAGE('CMS Title purge script finished successfully');
    ELSE
      insert_log_message('Title delete criteria is not correct');
    END IF;
    COMMIT;
  EXCEPTION
	  WHEN OTHERS THEN
      ROLLBACK;
      enable_disable_const('MDM_ASSET','E','Y');
	  	err_msg :=SUBSTR(SQLERRM, 1, 500);
			insert_log_message(err_msg);
  END purge_title_olddata;
END PURGE_CMS_TITLES;
/
exit
