/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.upgrade;

import com.tandbergtv.metadatamanager.util.XPathTranslator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SpecPluginUpdater {
    private static final String RESOURCE_DIR = "resources";
    public static String HELP = "Enter the name of the file to process.";
    private String mappingResource;
    private String specSpecificTTVXpathsFileName;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Please provide the path to the plugin directory.");
            return;
        }
        String dirName = args[0];
        File dir = new File(dirName);
        if (!dir.exists()) {
            System.err.println("Can't find directory: " + dirName);
            return;
        }
        SpecPluginUpdater updater = new SpecPluginUpdater(dir);
        updater.handleSpecSpecificXpaths();
        updater.handleMappingResources();
        System.out.println("Upgraded successfully");
    }

    public SpecPluginUpdater(File rootFolder) throws Exception {
        this.lookupFilePaths(rootFolder);
    }

    private void lookupFilePaths(File folder) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(false);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        docBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(SpecPluginUpdater.class.getResourceAsStream("plugin_1_0.dtd"));
            }
        });
        Document doc = docBuilder.parse(new File(folder, "plugin.xml"));
        NodeList params = doc.getElementsByTagName("parameter");
        for (int i = 0; i < params.getLength() && (this.mappingResource == null || this.specSpecificTTVXpathsFileName == null); ++i) {
            Node node = params.item(i);
            if (node.getAttributes().getNamedItem("id").getTextContent().equals("mappingResource")) {
                this.mappingResource = this.getResourceAbsolutePath(folder, node);
                continue;
            }
            if (!node.getAttributes().getNamedItem("id").getTextContent().equals("specSpecificTTVXpathsFileName")) continue;
            this.specSpecificTTVXpathsFileName = this.getResourceAbsolutePath(folder, node);
        }
        if (this.specSpecificTTVXpathsFileName == null) {
            throw new Exception("Can't find property \"specSpecificTTVXpathsFileName\" in plugin.xml");
        }
        if (this.mappingResource == null) {
            throw new Exception("Can't find property \"mappingResource\" in plugin.xml");
        }
    }

    private String getResourceAbsolutePath(File dir, Node node) {
        return dir.getAbsolutePath() + File.separator + RESOURCE_DIR + File.separator + node.getAttributes().getNamedItem("value").getTextContent();
    }

    private void handleSpecSpecificXpaths() throws Exception {
        File original = new File(this.specSpecificTTVXpathsFileName);
        if (!original.exists()) {
            throw new Exception("Can't find file: " + this.specSpecificTTVXpathsFileName);
        }
        String newFileName = this.specSpecificTTVXpathsFileName + ".new";
        File newFile = new File(newFileName);
        FileWriter fstream = new FileWriter(newFile, false);
        BufferedWriter out = new BufferedWriter(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(original)));
        String currLine = br.readLine();
        XPathTranslator translater = new XPathTranslator();
        while (currLine != null) {
            if (currLine.startsWith("/")) {
                out.write(translater.translateTTVtoECMF(currLine));
            } else {
                out.write(currLine);
            }
            out.newLine();
            currLine = br.readLine();
        }
        br.close();
        out.close();
        original.renameTo(new File(this.specSpecificTTVXpathsFileName + ".bak"));
        newFile.renameTo(new File(this.specSpecificTTVXpathsFileName));
    }

    private void handleMappingResources() throws Exception {
        File original = new File(this.mappingResource);
        if (!original.exists()) {
            throw new Exception("Can't find file: " + this.mappingResource);
        }
        String newFileName = this.mappingResource + ".new";
        File newFile = new File(newFileName);
        FileWriter fstream = new FileWriter(newFile, false);
        BufferedWriter out = new BufferedWriter(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(original)));
        String currLine = br.readLine();
        XPathTranslator translater = new XPathTranslator();
        while (currLine != null) {
            if (currLine.startsWith("[")) {
                out.write(currLine);
                out.newLine();
                continue;
            }
            String[] splitValue = currLine.split(", ");
            if (splitValue.length != 2) {
                throw new Exception("mapping fields should include an alias followed by an xpath comma delimmeted. Could not parse: " + currLine);
            }
            out.write(splitValue[0]);
            out.write(", ");
            out.write(translater.translateTTVtoECMF(splitValue[1]));
            out.newLine();
            currLine = br.readLine();
        }
        br.close();
        out.close();
        original.renameTo(new File(this.mappingResource + ".bak"));
        newFile.renameTo(new File(this.mappingResource));
    }
}

