/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.upgrade.categorymgmt;

import com.ericsson.cms.upgrade.utils.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class CategoryLoader {
    private static final int DEFAULT_MAX_CATEGORIES_TO_LOAD = 1000000;
    private static final String extractCategoryPathSQL = "SELECT DISTINCT case substr(CAT.CATEGORIES,1,1) when '/' then substr(CAT.CATEGORIES,2) else CAT.CATEGORIES end FROM wfs.MDM_METADATA MDM, wfs.PMM_TITLE P, XMLTABLE('/ECMFSpec//*/Fields/Categories/Category' PASSING MDM.OBJECT_VALUE columns Categories varchar2(4000) path 'Text' ) cat where p.mdmdocid = xmlcast(xmlquery('$p/ECMFSpec/@documentId' passing mdm.object_value as \"p\" returning content) as number)";
    private static final String categoryPathExistSQL = "SELECT count(*) from VW_CAT_CATEGORY_PATHS where path = ?";
    private static final String insertCategorySQL = "INSERT into CAT_CATEGORY (NAME, PARENT_CATEGORY_ID, INTERNAL_VERSION) values(?,?,1)";
    private static final String findParentIdSQL = "SELECT ID from VW_CAT_CATEGORY_PATHS where path = ?";
    private static final String CATEGORYPATH_DELIMITER = "/";
    private static List<String> invalidPaths = new ArrayList<String>();
    private static List<String> categoryPathsAlreadyExist = new ArrayList<String>();
    private static List<String> validCategoryPaths = new ArrayList<String>();

    private static void scanExtractedCategoryPath(Connection conn, List<String> categoryPathList) throws SQLException {
        System.out.println("\nScanning the extracted path for valid and if already exist");
        for (String path : categoryPathList) {
            if (!CategoryLoader.isValidPath(path)) {
                invalidPaths.add(path);
                continue;
            }
            if (CategoryLoader.categoryAlreadyExist(conn, path)) {
                categoryPathsAlreadyExist.add(path);
                continue;
            }
            validCategoryPaths.add(path);
        }
        if (invalidPaths.size() > 0) {
            System.out.println("\nFound following '" + invalidPaths.size() + "' invalid paths:");
            for (String path : invalidPaths) {
                System.out.println(path);
            }
        }
        if (categoryPathsAlreadyExist.size() > 0) {
            System.out.println("\nFound following '" + categoryPathsAlreadyExist.size() + "' category path already exist:");
            for (String path : categoryPathsAlreadyExist) {
                System.out.println(path);
            }
        }
        if (validCategoryPaths.size() > 0) {
            System.out.println("\nFound following '" + validCategoryPaths.size() + "' valid category path to insert in database:");
            for (String path : validCategoryPaths) {
                System.out.println(path);
            }
        } else {
            System.out.println("\nNo new category path is available to insert in database");
        }
        System.out.println("\nCompleted scanning the extracted path");
    }

    private static void createCategories(Connection conn) throws SQLException {
        System.out.println("\nStart creating/inserting category in database");
        for (String path : validCategoryPaths) {
            CategoryLoader.insertRecord(conn, path);
        }
        System.out.println("\nCompleted creating/inserting category in database");
    }

    private static void insertRecord(Connection conn, String path) throws SQLException {
        String temp = null;
        for (String str : path.split(CATEGORYPATH_DELIMITER)) {
            long parentId;
            if (temp == null) {
                temp = str;
                if (CategoryLoader.categoryAlreadyExist(conn, temp)) continue;
                CategoryLoader.insert(conn, temp, new Long(0L));
                continue;
            }
            String tempPath = "";
            tempPath = temp + CATEGORYPATH_DELIMITER + str;
            if (!CategoryLoader.categoryAlreadyExist(conn, tempPath) && (parentId = CategoryLoader.findParentId(conn, temp)) != -1L) {
                CategoryLoader.insert(conn, str, parentId);
            }
            temp = temp + CATEGORYPATH_DELIMITER + str;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long findParentId(Connection conn, String path) throws SQLException {
        ResultSet rs = null;
        PreparedStatement pst = null;
        try {
            pst = conn.prepareStatement(findParentIdSQL);
            pst.setString(1, path);
            rs = pst.executeQuery();
            if (rs != null && rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (pst != null) {
                pst.close();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insert(Connection conn, String name, long parentId) throws SQLException {
        PreparedStatement pst = null;
        try {
            pst = conn.prepareStatement(insertCategorySQL);
            pst.setString(1, name);
            pst.setLong(2, parentId);
            int count = pst.executeUpdate();
            if (count > 0) {
                System.out.println("category '" + name + "' Successfully inserted");
            }
        }
        finally {
            if (pst != null) {
                pst.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> extractCategoryPath(Connection conn) throws SQLException {
        System.out.println("\nStart extracting the category paths");
        ArrayList<String> categoryPathList = new ArrayList<String>();
        ResultSet rs = null;
        Statement st = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(extractCategoryPathSQL);
            if (rs != null) {
                int counter = 0;
                while (rs.next()) {
                    categoryPathList.add(rs.getString(1));
                    if (++counter < 1000000) continue;
                    String infoMsg = "Default Max Categories : 1000000 loaded.";
                    System.out.println(infoMsg);
                    infoMsg = "No more Categories will be loaded now...";
                    System.out.println(infoMsg);
                    break;
                }
            }
            if (categoryPathList.size() > 0) {
                System.out.println("\nExtracted following '" + categoryPathList.size() + "' category paths:");
                for (String path : categoryPathList) {
                    System.out.println(path);
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
        System.out.println("\nCompleted extracting the category paths");
        return categoryPathList;
    }

    private static boolean isValidPath(String path) {
        return !path.startsWith(CATEGORYPATH_DELIMITER) && path.indexOf("//") <= 0 && !path.endsWith(CATEGORYPATH_DELIMITER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean categoryAlreadyExist(Connection conn, String path) throws SQLException {
        int count = 0;
        ResultSet rs = null;
        PreparedStatement pst = null;
        try {
            pst = conn.prepareStatement(categoryPathExistSQL);
            pst.setString(1, path);
            rs = pst.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    count = Integer.parseInt(rs.getString(1));
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (pst != null) {
                pst.close();
            }
        }
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Connection conn = null;
        try {
            System.out.println("\nStarting the category load upgrade process");
            conn = DBUtils.getDBConnection(args);
            if (conn != null) {
                List<String> path = CategoryLoader.extractCategoryPath(conn);
                CategoryLoader.scanExtractedCategoryPath(conn, path);
                if (validCategoryPaths.size() > 0) {
                    CategoryLoader.createCategories(conn);
                }
            }
            System.out.println("\nCompleted the category load upgrade process");
        }
        catch (SQLException sqle) {
            System.out.println("\nFailure in the category load upgrade process");
            sqle.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("\nFailure in the category load upgrade process");
            ex.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }
}

