/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.util;

import com.ericsson.metadatamanager.util.FastFieldBinder;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.util.ResourceResolver;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import com.tandbergtv.metadatamanager.util.binder.AssetType;
import com.tandbergtv.metadatamanager.util.binder.ECMFFieldBinder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ECMFDocToXpathConverter {
    private Map<String, String> lookUp = new TreeMap<String, String>();
    private DocumentBuilder builder;
    private Transformer transformer;
    private static final Logger logger = Logger.getLogger(ECMFDocToXpathConverter.class);
    public static final String XSLT = "com/tandbergtv/metadatamanager/util/binder/xpath.xsl";

    public ECMFDocToXpathConverter() {
        try {
            this.builder = XmlUtil.createDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.builder = null;
        }
        InputStream is = ECMFFieldBinder.class.getClassLoader().getResourceAsStream(XSLT);
        try {
            TransformerFactory tf = XmlUtil.createTransformerFactory((ClassLoader)this.getClass().getClassLoader());
            tf.setURIResolver((URIResolver)new ResourceResolver());
            this.transformer = tf.newTransformer(new StreamSource(is));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> convert(Document doc) {
        NodeList nodeList = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node packageNode = nodeList.item(i);
            if (packageNode.getNodeType() != 1) continue;
            Element packageElement = (Element)packageNode;
            Group packageAsset = null;
            if (!packageElement.getNodeName().equalsIgnoreCase(Group.GroupType.PACKAGE.name())) continue;
            packageAsset = new Group();
            packageAsset.setType(Group.GroupType.PACKAGE.name());
            this.prepAsset((Asset)packageAsset, packageElement, true);
            for (int j = 0; j < packageNode.getChildNodes().getLength(); ++j) {
                Asset childAsset;
                Node packageChild = packageNode.getChildNodes().item(j);
                if (!(packageChild instanceof Element) || (childAsset = this.getAsset((Element)packageChild)) == null) continue;
                packageAsset.addChild(childAsset);
            }
        }
        return this.lookUp;
    }

    private Asset getAsset(Element assetElement) {
        if (assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.FILE.name())) {
            File fileAsset = new File();
            this.prepFile(fileAsset, assetElement);
            return fileAsset;
        }
        if (assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.TITLE.name())) {
            Item titleAsset = new Item();
            titleAsset.setType(Item.ItemType.TITLE);
            this.prepAsset((Asset)titleAsset, assetElement, true);
            return titleAsset;
        }
        if (assetElement.getNodeName().equalsIgnoreCase(Group.GroupType.MOVIE.name()) || assetElement.getNodeName().equalsIgnoreCase(Group.GroupType.PREVIEW.name())) {
            Group groupAsset = new Group();
            groupAsset.setType(assetElement.getNodeName().toUpperCase());
            this.prepAsset((Asset)groupAsset, assetElement, true);
            List<Element> fileElements = this.getNamedChildren(assetElement, AssetType.FILE.toString());
            for (int i = 0; i < fileElements.size(); ++i) {
                File fileAsset = new File();
                this.prepFile(fileAsset, fileElements.get(i));
                groupAsset.addChild((Asset)fileAsset);
            }
            this.prepLogicalClip(groupAsset, assetElement);
            return groupAsset;
        }
        if (assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.POSTER.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.BOXCOVER.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.TRICK.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.BARKER.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.ENCRYPTED.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.MOVIESEGMENTGROUP.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.PREVIEWSEGMENTGROUP.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.DISPLAY.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.GAME.name())) {
            Item itemAsset = new Item();
            itemAsset.setType(assetElement.getNodeName().toUpperCase());
            this.prepAsset((Asset)itemAsset, assetElement, true);
            List<Element> fileElements = this.getNamedChildren(assetElement, AssetType.FILE.toString());
            for (int i = 0; i < fileElements.size(); ++i) {
                File fileAsset = new File();
                this.prepFile(fileAsset, fileElements.get(i));
                itemAsset.addChild((Asset)fileAsset);
            }
            return itemAsset;
        }
        return null;
    }

    private void prepFile(File fileAsset, Element fileElement) {
        NodeList fieldNodeList = fileElement.getElementsByTagName("Fields");
        if (fieldNodeList.getLength() == 1) {
            // empty if block
        }
        this.prepAsset((Asset)fileAsset, fileElement, false);
        List<Element> fileElements = this.getNamedChildren(fileElement, AssetType.FILE.toString());
        for (Element f : fileElements) {
            File childFileAsset = new File();
            this.prepFile(childFileAsset, f);
            fileAsset.addChild((Asset)childFileAsset);
        }
    }

    private void prepLogicalClip(Group groupAsset, Element groupAssetElement) {
        List<Element> lcElements = this.getNamedChildren(groupAssetElement, AssetType.LOGICALCLIP.toString());
        for (int i = 0; i < lcElements.size(); ++i) {
            Item lcAsset = new Item();
            lcAsset.setType(Item.ItemType.LOGICALCLIP);
            List<Element> lcFileElements = this.getNamedChildren(lcElements.get(i), AssetType.FILE.toString());
            if (lcFileElements != null && lcFileElements.size() > 0) {
                for (Element f : lcFileElements) {
                    File lcFileAsset = new File();
                    this.prepFile(lcFileAsset, f);
                    lcAsset.addChild((Asset)lcFileAsset);
                }
            }
            this.prepAsset((Asset)lcAsset, lcElements.get(i), false);
            groupAsset.addChild((Asset)lcAsset);
        }
    }

    private Map<String, String> prepAsset(Asset asset, Element assetElement, boolean setOriginalRevisionNumber) {
        Element upFields;
        StringBuilder assetLineage = new StringBuilder();
        this.getAssetLineage(assetElement, assetLineage);
        Document fieldDoc = this.getFieldsDoc(assetElement);
        if (fieldDoc == null) {
            return this.lookUp;
        }
        FastFieldBinder binder = new FastFieldBinder();
        binder.extractXPaths(fieldDoc, this.transformer, this.lookUp);
        if (this.getNamedChildren(assetElement, "UnparsableFields").size() == 1 && (upFields = this.getNamedChildren(assetElement, "UnparsableFields").get(0)) != null) {
            binder.getUnParsableFields(upFields, this.lookUp);
        }
        return this.lookUp;
    }

    private void getAssetLineage(Element assetElement, StringBuilder assetLineage) {
        if (assetElement == null) {
            return;
        }
        if (assetElement.getParentNode() != null && !assetElement.getParentNode().getNodeName().equalsIgnoreCase("ECMFSpec")) {
            this.getAssetLineage((Element)assetElement.getParentNode(), assetLineage);
        }
        if (assetLineage.length() > 0) {
            assetLineage.append("/");
        }
        assetLineage.append(assetElement.getNodeName());
    }

    private Document getFieldsDoc(Element assetElement) {
        List<Element> namedChildren = this.getNamedChildren(assetElement, "Fields");
        if (namedChildren.size() == 0) {
            return null;
        }
        Element fields = namedChildren.get(0);
        Document fieldDoc = this.builder.newDocument();
        Element fieldsCopy = (Element)fieldDoc.importNode(fields, true);
        fieldDoc.appendChild(fieldsCopy);
        return fieldDoc;
    }

    private List<Element> getNamedChildren(Element element, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node elementChild = children.item(i);
            if (elementChild == null || !elementChild.getNodeName().equals(name)) continue;
            result.add((Element)elementChild);
        }
        return result;
    }
}

