/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.util;

import com.ericsson.metadatamanager.util.AssetConverter;
import com.ericsson.metadatamanager.util.AssetReader;
import com.ericsson.metadatamanager.util.DocumentLoader;
import com.ericsson.metadatamanager.util.Table;
import com.tandbergtv.metadatamanager.model.Asset;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import oracle.jdbc.driver.OracleDriver;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Loader {
    private static String url;
    private static String user;
    private static String pwd;
    private static int ConnectionPoolSize;
    private static int BatchSize;
    private static int NumThreads;
    private static int MaxNumBatchToLoad;
    private static boolean CheckAndLoadXml;
    private static boolean abortIfNotEmpty;
    private static String InvalidLatestXmlFolder;
    private static String InvalidRevisionXmlFolder;
    private static final Logger logger;
    private PoolDataSource pds;
    private ExecutorService executor;
    private int NumBatches = 0;
    private int NumDocsProcessed = 0;
    private int NumBatchesLoaded = 0;
    private List<Integer> badLots = new Vector<Integer>();

    public Loader() {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            this.pds = PoolDataSourceFactory.getPoolDataSource();
            this.pds.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
            this.pds.setURL(url);
            this.pds.setUser(user);
            this.pds.setPassword(pwd);
            this.pds.setInitialPoolSize(ConnectionPoolSize);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error registering driver and creating connection pool");
        }
    }

    synchronized void updateNumDocsProcessed(int num) {
        this.NumDocsProcessed += num;
    }

    synchronized int getNumDocsProcessed() {
        return this.NumDocsProcessed;
    }

    synchronized void updateNumBatchesLoaded(int num) {
        this.NumBatchesLoaded += num;
    }

    synchronized int getNumBatchesLoaded() {
        return this.NumBatchesLoaded;
    }

    public Connection getConnection() {
        Connection conn = this.getConnectionFromPool();
        return conn;
    }

    private Connection getConnectionFromPool() {
        Connection conn = null;
        try {
            conn = this.pds.getConnection();
        }
        catch (SQLException e) {
            logger.info((Object)("Not able to get connection from pool:" + e.getMessage()));
            conn = this.getNonPooledConnection();
        }
        return conn;
    }

    private Connection getNonPooledConnection() {
        Connection conn;
        try {
            conn = DriverManager.getConnection(url, user, pwd);
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error connecting to database");
        }
        return conn;
    }

    public void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.commit();
                conn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchAndAssignTask(boolean isLatestVersion) {
        Connection conn = this.getConnection();
        String sql = "select r.asset_id,r.revisionnumber from pmm_title t, mdm_asset a, mdm_rootassetrevision r where t.asset_id = r.asset_id and r.asset_id = a.id ";
        sql = sql + "and a.state=1 ";
        sql = isLatestVersion ? sql + "and r.revisionnumber = a.latestrevision " : sql + "and r.revisionnumber <> a.latestrevision ";
        sql = sql + "order by r.asset_id,r.revisionnumber";
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            ResultSet rset = stmt.executeQuery();
            ArrayList<Long> assetIds = new ArrayList<Long>();
            ArrayList<Integer> revisions = new ArrayList<Integer>();
            int count = 0;
            while (rset.next()) {
                Long assetId = rset.getLong(1);
                Integer desiredRevision = rset.getInt(2);
                if (assetId != null && desiredRevision != null) {
                    assetIds.add(assetId);
                    revisions.add(desiredRevision);
                    ++count;
                }
                if (count < BatchSize) continue;
                Runnable task = null;
                boolean skip = false;
                if (CheckAndLoadXml) {
                    if (this.badLots.contains(this.NumBatches)) {
                        task = new BadLotTask(isLatestVersion, assetIds, revisions);
                    } else {
                        skip = true;
                    }
                } else {
                    task = new LoadTask(this.NumBatches, isLatestVersion, assetIds, revisions);
                }
                if (!skip) {
                    this.executor.execute(task);
                }
                ++this.NumBatches;
                count = 0;
                assetIds = new ArrayList();
                revisions = new ArrayList();
                if (MaxNumBatchToLoad == 0 || this.NumBatches <= MaxNumBatchToLoad) continue;
                logger.info((Object)"Exceeded the maximum number of batches, exiting......");
                break;
            }
            if (assetIds.size() > 0) {
                Runnable task = null;
                boolean skip = false;
                if (CheckAndLoadXml) {
                    if (this.badLots.contains(this.NumBatches)) {
                        task = new SearchTask(isLatestVersion, assetIds, revisions);
                    } else {
                        skip = true;
                    }
                } else {
                    task = new LoadTask(this.NumBatches, isLatestVersion, assetIds, revisions);
                }
                if (!skip) {
                    this.executor.execute(task);
                }
                ++this.NumBatches;
            }
            stmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public void loadByBatches() {
        this.NumBatches = 0;
        this.NumDocsProcessed = 0;
        this.NumBatchesLoaded = 0;
        logger.info((Object)"Start converting and loading  metadata...");
        long start = System.currentTimeMillis();
        this.executor = Executors.newFixedThreadPool(NumThreads);
        this.batchAndAssignTask(true);
        this.batchAndAssignTask(false);
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
        }
        logger.info((Object)("Batch Size=" + BatchSize + " # of Threads=" + NumThreads));
        logger.info((Object)("Finished all threads: # batches processed = " + this.NumBatches + " # batches loaded with no error = " + this.NumBatchesLoaded));
        logger.info((Object)("Total time taken = " + (System.currentTimeMillis() - start) / 1000L + " seconds"));
    }

    public void reloadBadLots() {
        if (this.badLots.size() < 1) {
            System.out.println("No bad lots....");
            return;
        }
        logger.info((Object)("# of bad batches = " + this.badLots.size()));
        this.NumBatches = 0;
        this.NumDocsProcessed = 0;
        this.NumBatchesLoaded = 0;
        CheckAndLoadXml = true;
        logger.info((Object)"Trying to fix and reload bad batches...");
        long start = System.currentTimeMillis();
        this.executor = Executors.newFixedThreadPool(NumThreads);
        this.batchAndAssignTask(true);
        this.batchAndAssignTask(false);
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
        }
        logger.info((Object)("Batch Size=" + BatchSize + " # of Threads=" + NumThreads));
        logger.info((Object)("Finished all threads: # batches processed = " + this.NumBatches + " Total # xmls loaded = " + this.NumDocsProcessed));
        logger.info((Object)("Total time taken to load bad lots = " + (System.currentTimeMillis() - start) / 1000L + " seconds"));
        System.out.println("Loading completed.");
    }

    private static void readProperties(String propertyFilePath) {
        Properties prop = new Properties();
        try {
            String maxNumBatchToLoad;
            String numThreads;
            String batchSize;
            FileInputStream fis = new FileInputStream(propertyFilePath);
            prop.load(fis);
            url = prop.getProperty("url");
            user = prop.getProperty("user");
            pwd = prop.getProperty("pwd");
            String poolSize = prop.getProperty("ConnectionPoolSize");
            if (poolSize != null) {
                ConnectionPoolSize = Integer.parseInt(poolSize);
            }
            if ((batchSize = prop.getProperty("BatchSize")) != null) {
                BatchSize = Integer.parseInt(batchSize);
            }
            if ((numThreads = prop.getProperty("NumThreads")) != null) {
                NumThreads = Integer.parseInt(numThreads);
            }
            if ((maxNumBatchToLoad = prop.getProperty("MaxNumBatchToLoad")) != null) {
                MaxNumBatchToLoad = Integer.parseInt(maxNumBatchToLoad);
            }
            InvalidLatestXmlFolder = prop.getProperty("InvalidLatestXmlFolder");
            InvalidRevisionXmlFolder = prop.getProperty("InvalidRevisionXmlFolder");
            String AbortIfNotEmpty = prop.getProperty("AbortIfNotEmpty");
            if (AbortIfNotEmpty != null) {
                abortIfNotEmpty = Boolean.parseBoolean(AbortIfNotEmpty);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error reading property file");
        }
    }

    private static void printProperties() {
        logger.info((Object)"Load Properties:");
        logger.info((Object)("url=" + url));
        logger.info((Object)("user=" + user));
        logger.info((Object)("pwd=" + pwd));
        logger.info((Object)("ConnectionPoolSize=" + ConnectionPoolSize));
        logger.info((Object)("BatchSize=" + BatchSize));
        logger.info((Object)("NumThreads=" + NumThreads));
        logger.info((Object)("MaxNumBatchToLoad=" + MaxNumBatchToLoad));
        logger.info((Object)("InvalidLatestXmlFolder=" + InvalidLatestXmlFolder));
        logger.info((Object)("InvalidRevisionXmlFolder=" + InvalidRevisionXmlFolder));
        logger.info((Object)("AbortIfNotEmpty=" + abortIfNotEmpty));
    }

    static void cleanUp(Connection con) {
        try {
            con.close();
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    public static void main(String[] args) {
        long count;
        System.out.println("Initializing....");
        PropertyConfigurator.configure((String)"log4j.properties");
        Loader.readProperties("metadata_upgrade.properties");
        Loader.printProperties();
        Loader loader = new Loader();
        Table db = new Table();
        Connection con = loader.getConnection();
        if (args.length > 0) {
            long count2 = db.getCountMdmMetadata(con);
            if (count2 < 1L) {
                System.out.println("No data in mdm_metadata.");
                logger.info((Object)"No data in mdm_metadata.");
                Loader.cleanUp(con);
                return;
            }
            try {
                AssetConverter.main(args);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            return;
        }
        if (abortIfNotEmpty && (count = db.getCountMdmMetadata(con)) > 0L) {
            System.out.println("Metadata migration aborted.");
            logger.info((Object)("Metadata migration aborted. There are existing data in mdm_metadata. Count=" + count));
            Loader.cleanUp(con);
            return;
        }
        db.updateDatabaseBeforeMigration(con);
        Loader.cleanUp(con);
        System.out.println("Upgrading and loading metadata....");
        loader.loadByBatches();
        System.out.println("Loading(1st pass) completed.");
        con = loader.getConnection();
        db.updateMdmDocId(con);
        try {
            con.commit();
            con.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        System.out.println("Recreating indices for mdm_metadata & mdm_metadata_revision...");
        con = loader.getNonPooledConnection();
        db.updateDatabaseAfterMigration(con);
        try {
            loader.closeConnection(con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Reloading bad lots....");
        loader.reloadBadLots();
        System.out.println("Done.");
        logger.info((Object)"Done.");
    }

    static {
        ConnectionPoolSize = 5;
        BatchSize = 10;
        NumThreads = 2;
        MaxNumBatchToLoad = 0;
        CheckAndLoadXml = false;
        abortIfNotEmpty = false;
        InvalidLatestXmlFolder = "c:/content/bad/mdm_metadata";
        InvalidRevisionXmlFolder = "c:/content/bad/mdm_metadata_revision";
        logger = Logger.getLogger(Loader.class);
    }

    class BadLotTask
    implements Runnable {
        boolean isLatest;
        List<Long> assetIds;
        List<Integer> revisions;

        BadLotTask(boolean isLatest, List<Long> assetIds, List<Integer> revisions) {
            this.isLatest = isLatest;
            this.assetIds = assetIds;
            this.revisions = revisions;
        }

        @Override
        public void run() {
            boolean checkForValidXPath = true;
            AssetReader assetReader = new AssetReader();
            DocumentLoader docLoader = new DocumentLoader();
            long t1 = System.currentTimeMillis();
            Connection xmlConn = Loader.this.getConnection();
            int numXmlProcessed = 0;
            for (int i = 0; i < this.assetIds.size(); ++i) {
                int loaded = docLoader.isLoaded(xmlConn, this.isLatest, this.assetIds.get(i), this.revisions.get(i));
                if (loaded >= 1) continue;
                Connection conn = Loader.this.getConnection();
                assetReader.setConnection(conn);
                Asset assetModel = assetReader.getAssetModel(this.assetIds.get(i), this.revisions.get(i), this.isLatest);
                String xml = docLoader.convertToXml(assetModel, checkForValidXPath);
                assetReader.closeConnection();
                ArrayList<String> list = new ArrayList<String>();
                list.add(xml);
                int numLoaded = docLoader.loadXmls(xmlConn, this.isLatest, list);
                if (numLoaded < 1) {
                    logger.info((Object)("*** Fail to save xml docId=" + this.assetIds.get(i) + " revision=" + this.revisions.get(i) + " mdm_metadata=" + this.isLatest));
                    continue;
                }
                ++numXmlProcessed;
            }
            Loader.this.closeConnection(xmlConn);
            long t2 = System.currentTimeMillis();
            int batchSize = this.assetIds.size();
            Loader.this.updateNumDocsProcessed(numXmlProcessed);
            Loader.this.updateNumBatchesLoaded(1);
            logger.info((Object)("2nd Pass:# docs loaded =" + numXmlProcessed + " batch size=" + batchSize + "  time to process=" + (t2 - t1) + " ms" + "  mdm_metadata=" + this.isLatest + "  #batches checked=" + Loader.this.getNumBatchesLoaded()));
        }
    }

    class SearchTask
    implements Runnable {
        boolean isLatest;
        List<Long> assetIds;
        List<Integer> revisions;

        SearchTask(boolean isLatest, List<Long> assetIds, List<Integer> revisions) {
            this.isLatest = isLatest;
            this.assetIds = assetIds;
            this.revisions = revisions;
        }

        @Override
        public void run() {
            boolean checkForValidXPath = true;
            AssetReader assetReader = new AssetReader();
            DocumentLoader docLoader = new DocumentLoader();
            long t1 = System.currentTimeMillis();
            Connection xmlConn = Loader.this.getConnection();
            int numXmlProcessed = 0;
            for (int i = 0; i < this.assetIds.size(); ++i) {
                int loaded = docLoader.checkAndLog(xmlConn, this.isLatest, this.assetIds.get(i), this.revisions.get(i));
                if (loaded >= 1) continue;
                Connection conn = Loader.this.getConnection();
                assetReader.setConnection(conn);
                Asset assetModel = assetReader.getAssetModel(this.assetIds.get(i), this.revisions.get(i), this.isLatest);
                String xml = docLoader.convertToXml(assetModel, checkForValidXPath);
                assetReader.closeConnection();
                if (CheckAndLoadXml) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(xml);
                    int numLoaded = docLoader.loadXmls(xmlConn, this.isLatest, list);
                    if (numLoaded < 1) {
                        logger.info((Object)("*** Fail to save xml docId=" + this.assetIds.get(i) + " revision=" + this.revisions.get(i) + " mdm_metadata=" + this.isLatest));
                    }
                    numXmlProcessed += numLoaded;
                    continue;
                }
                docLoader.logXml(this.isLatest, this.assetIds.get(i), this.revisions.get(i), xml);
                ++numXmlProcessed;
            }
            Loader.this.closeConnection(xmlConn);
            long t2 = System.currentTimeMillis();
            int batchSize = this.assetIds.size();
            Loader.this.updateNumDocsProcessed(numXmlProcessed);
            Loader.this.updateNumBatchesLoaded(1);
            logger.info((Object)("# docs loaded =" + numXmlProcessed + " batch size=" + batchSize + "  time to process=" + (t2 - t1) + " ms" + "  mdm_metadata=" + this.isLatest + "  #batches checked=" + Loader.this.getNumBatchesLoaded()));
        }
    }

    class LoadTask
    implements Runnable {
        int batchNum;
        boolean isLatest;
        List<Long> assetIds;
        List<Integer> revisions;

        LoadTask(int batchNum, boolean isLatest, List<Long> assetIds, List<Integer> revisions) {
            this.batchNum = batchNum;
            this.isLatest = isLatest;
            this.assetIds = assetIds;
            this.revisions = revisions;
        }

        @Override
        public void run() {
            boolean checkForValidXPath = false;
            AssetReader assetReader = new AssetReader();
            DocumentLoader docLoader = new DocumentLoader();
            ArrayList<String> xmls = new ArrayList<String>();
            long t1 = System.currentTimeMillis();
            Connection conn = Loader.this.getConnection();
            assetReader.setConnection(conn);
            int bindTime = 0;
            for (int i = 0; i < this.assetIds.size(); ++i) {
                Asset assetModel = assetReader.getAssetModel(this.assetIds.get(i), this.revisions.get(i), this.isLatest);
                long t0 = System.currentTimeMillis();
                xmls.add(docLoader.convertToXml(assetModel, checkForValidXPath));
                bindTime = (int)((long)bindTime + (System.currentTimeMillis() - t0));
            }
            assetReader.closeConnection();
            long t2 = System.currentTimeMillis();
            int batchSize = this.assetIds.size();
            Connection xmlConn = Loader.this.getConnection();
            int numLoaded = docLoader.loadXmls(xmlConn, this.isLatest, xmls);
            boolean batchLoaded = false;
            if (numLoaded == 0) {
                logger.info((Object)("* Error in saving batch # " + this.batchNum + " root-asset-Ids:" + this.assetIds.toString() + "  and revisions=" + this.revisions.toString()));
                Loader.this.badLots.add(this.batchNum);
            } else {
                batchLoaded = true;
                Loader.this.updateNumBatchesLoaded(1);
            }
            Loader.this.closeConnection(xmlConn);
            long t3 = System.currentTimeMillis();
            logger.info((Object)("Batch num=" + this.batchNum + " size=" + batchSize + " successful=" + batchLoaded + "  read=" + (t2 - t1 - (long)bindTime) + " ms   bind= " + bindTime + "   xml save=" + (t3 - t2) + " ms" + "  mdm_metadata=" + this.isLatest + "  #batches loaded=" + Loader.this.getNumBatchesLoaded()));
        }
    }
}

