/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.util;

import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.OracleDriver;

public class AssetDB {
    private static String url;
    private static String user;
    private static String pwd;

    public AssetDB() {
        this.readProperties("metadata_upgrade.properties");
    }

    private void readProperties(String propertyFilePath) {
        Properties prop = new Properties();
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            FileInputStream fis = new FileInputStream(propertyFilePath);
            prop.load(fis);
            url = prop.getProperty("url");
            user = prop.getProperty("user");
            pwd = prop.getProperty("pwd");
            System.out.println("url=" + url);
            System.out.println("user=" + user);
            System.out.println("pwd=" + pwd);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error reading property file");
        }
    }

    public Connection getConnection() {
        Connection conn;
        try {
            conn = DriverManager.getConnection(url, user, pwd);
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException("Error connecting to database");
        }
        return conn;
    }

    public void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.commit();
                conn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

