/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.util;

import com.ericsson.metadatamanager.util.FastFieldBinder;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import com.tandbergtv.metadatamanager.util.binder.AssetType;
import com.tandbergtv.metadatamanager.util.binder.ECMFBinder;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AssetTreeToDocConverter {
    private DocumentBuilder builder;
    private Document doc;
    private static final Logger logger = Logger.getLogger(AssetTreeToDocConverter.class);

    public AssetTreeToDocConverter() {
        try {
            this.builder = XmlUtil.createDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.builder = null;
        }
    }

    public Document convert(List<Asset> assets) {
        long t1 = System.currentTimeMillis();
        this.doc = this.builder.newDocument();
        ArrayList<Element> elements = new ArrayList<Element>();
        if (assets.size() > 1) {
            logger.warn(assets.size() + " root assets have been requested to be converted into ECMF doc." + " Will convert only the first one.");
        }
        Asset asset = assets.get(0);
        elements.add(this.assetRoller(asset));
        Element root = this.doc.createElement("ECMFSpec");
        root.setAttribute("xsi:noNamespaceSchemaLocation", "ECMFSpec.xsd");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("documentId", String.valueOf(asset.getId()));
        root.setAttribute("revision", String.valueOf(asset.getLatestRevisionNumber()));
        if (asset.getOriginalAssetID() != null && asset.getOriginalAssetID() > 0L) {
            root.setAttribute("originalDocumentId", String.valueOf(asset.getOriginalAssetID()));
        }
        if (asset.getOriginalRevisionNumber() != null && asset.getOriginalRevisionNumber() > 0) {
            root.setAttribute("originalDocumentRevision", String.valueOf(asset.getOriginalRevisionNumber()));
        }
        this.doc.appendChild(root);
        for (Element element : elements) {
            if (element == null) continue;
            Node elementCopy = this.doc.importNode(element, true);
            root.appendChild(elementCopy);
        }
        long t2 = System.currentTimeMillis();
        long convertTime = t2 - t1;
        return this.doc;
    }

    private Element assetRoller(Asset packageAsset) {
        Element packageElement = this.buildAssetElement(packageAsset, true);
        List<Asset> titleAssets = packageAsset.getAllAssetsOfType(Item.ItemType.TITLE.name());
        if (titleAssets != null && titleAssets.size() == 1) {
            Element titleElement = this.buildAssetElement(titleAssets.get(0), true);
            for (Relation r : titleAssets.get(0).getRelations()) {
                List<Field> file_flds;
                if (!r.getTargetAsset().getType().equals(Item.ItemType.FILE.name()) || (file_flds = r.getTargetAsset().getFields()) == null || file_flds.isEmpty()) continue;
                Element fileElement = this.buildFileElement(r.getTargetAsset());
                titleElement.appendChild(fileElement);
            }
            titleElement.appendChild(this.buildFieldsElement(titleAssets.get(0)));
            Element upElement = this.buildUnparsableFieldsElement(titleAssets.get(0));
            if (upElement != null) {
                titleElement.appendChild(upElement);
            }
            packageElement.appendChild(titleElement);
        }
        this.addMovieOrPreviewElements(packageAsset, packageElement, Group.GroupType.MOVIE.name());
        this.addMovieOrPreviewElements(packageAsset, packageElement, Group.GroupType.PREVIEW.name());
        this.addMultipleAssetElements(packageAsset, packageElement, Item.ItemType.POSTER.name());
        this.addMultipleAssetElements(packageAsset, packageElement, Item.ItemType.BOXCOVER.name());
        this.addMultipleAssetElements(packageAsset, packageElement, Item.ItemType.TRICK.name());
        this.addMultipleAssetElements(packageAsset, packageElement, Item.ItemType.ENCRYPTED.name());
        this.addMultipleAssetElements(packageAsset, packageElement, Item.ItemType.BARKER.name());
        this.addMultipleAssetElements(packageAsset, packageElement, Item.ItemType.MOVIESEGMENTGROUP.name());
        this.addMultipleAssetElements(packageAsset, packageElement, Item.ItemType.PREVIEWSEGMENTGROUP.name());
        this.addMultipleAssetElements(packageAsset, packageElement, Item.ItemType.DISPLAY.name());
        this.addMultipleAssetElements(packageAsset, packageElement, Item.ItemType.GAME.name());
        for (Relation r : packageAsset.getRelations()) {
            List<Field> file_flds;
            if (!r.getTargetAsset().getType().equals(Item.ItemType.FILE.name()) || (file_flds = r.getTargetAsset().getFields()) == null || file_flds.isEmpty()) continue;
            Element fileElement = this.buildFileElement(r.getTargetAsset());
            packageElement.appendChild(fileElement);
        }
        packageElement.appendChild(this.buildFieldsElement(packageAsset));
        Element upElement = this.buildUnparsableFieldsElement(packageAsset);
        if (upElement != null) {
            packageElement.appendChild(upElement);
        }
        return packageElement;
    }

    private void addAssetElement(Asset packageAsset, Element packageElement, String itemType) {
        List<Asset> assets = packageAsset.getAllAssetsOfType(itemType);
        if (assets == null || assets.size() == 0) {
            return;
        }
        if (assets.size() > 1) {
            logger.debug("Found multiple assets of type: " + itemType + " Will add the first one to the doc.");
        }
        Element assetElement = this.buildAssetElement(assets.get(0), true);
        for (Relation r : assets.get(0).getRelations()) {
            List<Field> file_flds;
            if (!r.getTargetAsset().getType().equals(Item.ItemType.FILE.name()) || (file_flds = r.getTargetAsset().getFields()) == null || file_flds.isEmpty()) continue;
            Element fileElement = this.buildFileElement(r.getTargetAsset());
            assetElement.appendChild(fileElement);
        }
        Element fieldsElement = this.buildFieldsElement(assets.get(0));
        assetElement.appendChild(fieldsElement);
        Element upFieldsElement = this.buildUnparsableFieldsElement(assets.get(0));
        if (upFieldsElement != null) {
            assetElement.appendChild(upFieldsElement);
        }
        packageElement.appendChild(assetElement);
    }

    private void addMultipleAssetElements(Asset packageAsset, Element packageElement, String itemType) {
        List<Asset> assets = packageAsset.getAllAssetsOfType(itemType);
        if (assets == null || assets.size() == 0) {
            return;
        }
        for (Asset a : assets) {
            Element assetElement = this.buildAssetElement(a, true);
            for (Relation r : a.getRelations()) {
                List<Field> file_flds;
                if (!r.getTargetAsset().getType().equals(Item.ItemType.FILE.name()) || (file_flds = r.getTargetAsset().getFields()) == null || file_flds.isEmpty()) continue;
                Element fileElement = this.buildFileElement(r.getTargetAsset());
                assetElement.appendChild(fileElement);
            }
            Element fieldsElement = this.buildFieldsElement(a);
            assetElement.appendChild(fieldsElement);
            Element upFieldsElement = this.buildUnparsableFieldsElement(a);
            if (upFieldsElement != null) {
                assetElement.appendChild(upFieldsElement);
            }
            packageElement.appendChild(assetElement);
        }
    }

    private void addMovieOrPreviewElements(Asset packageAsset, Element packageElement, String groupType) {
        List<Asset> assets = packageAsset.getAllAssetsOfType(groupType);
        if (assets != null) {
            for (Asset a : assets) {
                Element assetElement = this.buildAssetElement(a, true);
                for (Relation r : a.getRelations()) {
                    if (!r.getTargetAsset().getType().equals(Item.ItemType.LOGICALCLIP.name())) continue;
                    Element logicalClipElement = this.buildLogicalClipElement(r.getTargetAsset());
                    assetElement.appendChild(logicalClipElement);
                }
                for (Relation r : a.getRelations()) {
                    List<Field> file_flds;
                    if (!r.getTargetAsset().getType().equals(Item.ItemType.FILE.name()) || (file_flds = r.getTargetAsset().getFields()) == null || file_flds.isEmpty()) continue;
                    Element fileElement = this.buildFileElement(r.getTargetAsset());
                    assetElement.appendChild(fileElement);
                }
                Element fieldsElement = this.buildFieldsElement(a);
                assetElement.appendChild(fieldsElement);
                Element upFieldsElement = this.buildUnparsableFieldsElement(a);
                if (upFieldsElement != null) {
                    assetElement.appendChild(upFieldsElement);
                }
                packageElement.appendChild(assetElement);
            }
        }
    }

    private Element buildLogicalClipElement(Asset logicalClipAsset) {
        Element logicalClipAssetElement = this.buildAssetElement(logicalClipAsset, false);
        for (Relation r : logicalClipAsset.getRelations()) {
            List<Field> file_flds;
            if (!r.getTargetAsset().getAssetType().equals(Item.ItemType.FILE.name()) || (file_flds = r.getTargetAsset().getFields()) == null || file_flds.isEmpty()) continue;
            Element fileElement = this.buildFileElement(r.getTargetAsset());
            logicalClipAssetElement.appendChild(fileElement);
        }
        Element fields = this.buildFieldsElement(logicalClipAsset);
        logicalClipAssetElement.appendChild(fields);
        Element upFields = this.buildUnparsableFieldsElement(logicalClipAsset);
        if (upFields != null) {
            logicalClipAssetElement.appendChild(upFields);
        }
        return logicalClipAssetElement;
    }

    private Element buildAssetElement(Asset asset, boolean setOriginalAssetId) {
        Element assetElement = this.doc.createElement(AssetType.valueOf(asset.getAssetType()).toString());
        assetElement.setAttribute("assetId", String.valueOf(asset.getTTVId().getId()));
        if (setOriginalAssetId && asset.getOriginalAssetID() != null && asset.getOriginalAssetID() > 0L) {
            assetElement.setAttribute("originalAssetId", String.valueOf(asset.getOriginalAssetID()));
        }
        return assetElement;
    }

    private Element buildFieldsElement(Asset asset) {
        ArrayList<Field> parsableFields = new ArrayList<Field>();
        for (Field f : asset.getFields()) {
            if (!f.getParsable().booleanValue()) continue;
            parsableFields.add(f);
        }
        FastFieldBinder fb = new FastFieldBinder();
        NodeList sourceFieldNodes = fb.buildXml(parsableFields).getDocumentElement().getChildNodes();
        Element fields = this.doc.createElement("Fields");
        for (int i = 0; i < sourceFieldNodes.getLength(); ++i) {
            Node item = sourceFieldNodes.item(i);
            if (!(item instanceof Element)) continue;
            fields.appendChild(this.doc.importNode(item, true));
        }
        return fields;
    }

    private Element buildUnparsableFieldsElement(Asset asset) {
        ArrayList<Field> unParsableFields = new ArrayList<Field>();
        for (Field f : asset.getFields()) {
            if (f.getParsable().booleanValue()) continue;
            unParsableFields.add(f);
        }
        FastFieldBinder fb = new FastFieldBinder();
        Document upfs = fb.buildUnparsableFields(unParsableFields);
        if (upfs == null) {
            return null;
        }
        NodeList sourceFieldNodes = upfs.getDocumentElement().getChildNodes();
        Element upFields = this.doc.createElement("UnparsableFields");
        for (int i = 0; i < sourceFieldNodes.getLength(); ++i) {
            Node item = sourceFieldNodes.item(i);
            if (!(item instanceof Element)) continue;
            upFields.appendChild(this.doc.importNode(item, true));
        }
        return upFields;
    }

    private Element buildFileElement(Asset fileAsset) {
        Element fileElement = this.doc.createElement(AssetType.FILE.toString());
        fileElement.setAttribute("assetId", String.valueOf(fileAsset.getTTVId().getId()));
        for (Relation r : fileAsset.getRelations()) {
            List<Field> file_flds;
            if (!r.getTargetAsset().getAssetType().equals(Item.ItemType.FILE.name()) || (file_flds = r.getTargetAsset().getFields()) == null || file_flds.isEmpty()) continue;
            Element childFileElement = this.buildFileElement(r.getTargetAsset());
            fileElement.appendChild(childFileElement);
        }
        Element fileFields = this.buildFieldsElement(fileAsset);
        fileElement.appendChild(fileFields);
        Element upFieldsElement = this.buildUnparsableFieldsElement(fileAsset);
        if (upFieldsElement != null) {
            fileElement.appendChild(upFieldsElement);
        }
        return fileElement;
    }

    public static void main(String[] args) {
        String inputFile = "C:/samples/xmls/ecmf_doc_cl1_1-sample_2.xml";
        try {
            File file = new File(inputFile);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            String rootNodeName = doc.getDocumentElement().getNodeName();
            System.out.println("...rootNodeName=" + rootNodeName);
            List<Asset> assets = new ECMFBinder().bind(doc);
            AssetTreeToDocConverter test = new AssetTreeToDocConverter();
            Document output = test.convert(assets);
            StringWriter out = new StringWriter();
            XMLSerializer serializer = new XMLSerializer(out, new OutputFormat(output, null, true));
            serializer.serialize(output);
            System.out.println(out.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

