/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.util;

import com.tandbergtv.metadatamanager.model.CustomField;
import com.tandbergtv.metadatamanager.model.Field;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FastFieldBinder {
    private static final Logger logger = Logger.getLogger(FastFieldBinder.class);
    public static final String _CUSTOMFIELD_NAME = "CustomField[@name=";
    private static final String CUSTOMFIELD = "CustomField";
    private static final String CUSTOMFIELDS = "CustomFields";
    public static final String VALUE = "Value";
    public static final String BOOLEANVALUE = "BooleanValue";
    public static final String INTEGERVALUE = "IntegerValue";
    public static final String FLOATVALUE = "FloatValue";
    public static final String DATETIMEVALUE = "DatetimeValue";
    public static final String TIMEVALUE = "TimeValue";
    private DocumentBuilder builder;

    public FastFieldBinder() {
        try {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.builder = null;
        }
    }

    public Document buildXml(List<Field> fields) {
        Document doc = this.builder.newDocument();
        Element root = doc.createElement("Fields");
        root.setAttribute("xmlns", "http://www.w3.org/2000/xmlns/");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:noNamespaceSchemaLocation", "ECMFSpec.xsd");
        doc.appendChild(root);
        HashMap<String, Node> nodeLookUp = new HashMap<String, Node>();
        HashMap multiValueNodesLookUp = new HashMap();
        nodeLookUp.put("/Fields[1]", root);
        ArrayList<Element> multivalueNodesForRoot = new ArrayList<Element>();
        multivalueNodesForRoot.add(root);
        multiValueNodesLookUp.put("/Fields", multivalueNodesForRoot);
        for (Field field : fields) {
            int i;
            String xpath = field.getTtvXPath();
            String attribute = "";
            if (xpath.indexOf("/@") > -1) {
                attribute = xpath.replaceFirst(".*/@", "");
                xpath = xpath.replaceFirst("/@.*", "");
            }
            String[] xpathSplit = xpath.split("/");
            List<Integer> indices = field.getIndices();
            String value = field.getValue();
            String xpathPart = "";
            Node node = null;
            if (indices.size() > xpathSplit.length - 1) {
                logger.error(" Invalid indices found in field: " + field.toString());
                ArrayList<Integer> corIndices = new ArrayList<Integer>();
                for (i = 0; i < xpathSplit.length - 1; ++i) {
                    corIndices.add(indices.get(i));
                }
                indices = corIndices;
            }
            boolean isCustomField = false;
            for (i = 0; i < indices.size(); ++i) {
                String xpathChild = xpathSplit[i + 1];
                int index = indices.get(i);
                if (xpathChild.contains(_CUSTOMFIELD_NAME)) {
                    node = (Node)nodeLookUp.get(xpathPart);
                    String cfName = this.extractCustomFieldName(xpathChild);
                    node = this.appendCustomFieldElement(doc, node, cfName, field);
                    isCustomField = true;
                } else {
                    ArrayList<Node> multiValueNodes = (ArrayList<Node>)multiValueNodesLookUp.get(xpathPart + "/" + xpathChild);
                    int numNodes = 0;
                    if (multiValueNodes == null) {
                        multiValueNodes = new ArrayList<Node>();
                        multiValueNodesLookUp.put(xpathPart + "/" + xpathChild, multiValueNodes);
                    } else {
                        numNodes = multiValueNodes.size();
                    }
                    if (numNodes >= index) {
                        node = (Node)multiValueNodes.get(index - 1);
                    } else {
                        for (int j = 0; j < index - numNodes; ++j) {
                            Node parent = (Node)nodeLookUp.get(xpathPart);
                            Element childNode = doc.createElement(xpathChild);
                            if (parent == null) {
                                logger.error(" Invalid node: field xpath=" + field.getTtvXPath() + "  xpathPart=" + xpathPart);
                            }
                            node = parent.appendChild(childNode);
                            multiValueNodes.add(node);
                            nodeLookUp.put(xpathPart + "/" + xpathChild + "[" + (j + numNodes + 1) + "]", node);
                        }
                    }
                }
                xpathPart = xpathPart + "/" + xpathChild + "[" + index + "]";
            }
            if (!attribute.equals("")) {
                if (!isCustomField) {
                    ((Element)node).setAttribute(attribute, value);
                    continue;
                }
                isCustomField = false;
                continue;
            }
            ((Element)node).setTextContent(value);
        }
        return doc;
    }

    Node appendCustomFieldElement(Document doc, Node parent, String cfName, Field field) {
        Element cfElem = doc.createElement(CUSTOMFIELD);
        cfElem.setAttribute("name", cfName);
        String dataType = field.getDataType();
        Element valueElem = null;
        valueElem = dataType.equals("integer") ? doc.createElement(INTEGERVALUE) : (dataType.equals("float") ? doc.createElement(FLOATVALUE) : (dataType.equals("date") ? doc.createElement(DATETIMEVALUE) : (dataType.equals("time") ? doc.createElement(TIMEVALUE) : (dataType.equals("boolean") ? doc.createElement(BOOLEANVALUE) : doc.createElement(VALUE)))));
        String value = field.getValue();
        valueElem.setTextContent(value);
        cfElem.appendChild(valueElem);
        Node node = parent.appendChild(cfElem);
        return node;
    }

    public Document buildUnparsableFields(List<Field> upFields) {
        if (upFields.size() == 0) {
            return null;
        }
        Document doc = this.builder.newDocument();
        Element root = doc.createElement("UnparsableFields");
        root.setAttribute("xmlns", "http://www.w3.org/2000/xmlns/");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:noNamespaceSchemaLocation", "ECMFSpec.xsd");
        doc.appendChild(root);
        for (Field f : upFields) {
            Element upFieldElement = doc.createElement("UnparsableField");
            upFieldElement.setAttribute("xpath", f.getTtvXPath());
            upFieldElement.setAttribute("value", f.getValue());
            StringBuilder sbIndices = new StringBuilder();
            for (Integer ind : f.getIndices()) {
                if (sbIndices.length() > 0) {
                    sbIndices.append(",");
                }
                sbIndices.append(ind);
            }
            upFieldElement.setAttribute("indices", sbIndices.toString());
            root.appendChild(upFieldElement);
        }
        return doc;
    }

    private String extractCustomFieldName(String xpathChild) {
        String cfName = "";
        String[] o = xpathChild.split("=");
        if (o.length == 2) {
            cfName = o[1];
            cfName = cfName.replaceAll("\\]", "");
        }
        return cfName;
    }

    public Map<String, String> extractXPaths(Document doc, Transformer transformer, Map<String, String> lookUp) {
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        try {
            transformer.transform(new DOMSource(doc), result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        String[] xpaths = sw.toString().split("#ttv#ttv#ttv#ttv#\n");
        for (String xpath : xpaths = this.handleCustomFieldXpaths(xpaths)) {
            String[] indexSplit;
            if (xpath.matches("/Fields\\{[0-9]*\\}/@.*")) continue;
            int equalSign = xpath.indexOf("==");
            String indexedXPath = xpath.substring(0, equalSign);
            lookUp.put(indexedXPath.replaceAll("\\{[0-9]*\\}", ""), xpath.substring(equalSign + 2));
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (String indexStr : indexSplit = indexedXPath.split("\\{")) {
                int bracket = indexStr.indexOf("}");
                if (bracket <= -1) continue;
                indices.add(Integer.parseInt(indexStr.substring(0, bracket)));
            }
        }
        return lookUp;
    }

    public Map<String, String> getUnParsableFields(Element upFields, Map<String, String> lookUp) {
        if (upFields == null) {
            return lookUp;
        }
        NodeList upFieldList = upFields.getElementsByTagName("UnparsableField");
        for (int i = 0; i < upFieldList.getLength(); ++i) {
            Element upf = (Element)upFieldList.item(i);
            String xpath = upf.getAttribute("xpath");
            if (xpath.isEmpty()) continue;
            String indicesStr = upf.getAttribute("indices");
            if (indicesStr != null) {
                ArrayList<Integer> indices = new ArrayList<Integer>();
                String[] ind = indicesStr.split(",");
                for (int j = 0; j < ind.length; ++j) {
                    if (ind[j].trim().isEmpty()) {
                        System.out.println(" Empty ..xpath=" + xpath + " indices=" + indicesStr);
                    }
                    indices.add(Integer.valueOf(ind[j].trim()));
                }
            }
            String value = upf.getAttribute("value");
            if (xpath == null || value == null) continue;
            lookUp.put(xpath, value);
        }
        return lookUp;
    }

    private String[] handleCustomFieldXpaths(String[] xpaths) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> cfList = new ArrayList<String>();
        for (String xpath : xpaths) {
            if (xpath.contains(CUSTOMFIELDS)) {
                cfList.add(xpath);
                continue;
            }
            list.add(xpath);
        }
        Collection<CustomField> customFields = this.getCustomFields(cfList);
        for (CustomField customField : customFields) {
            list.add(customField.constructTTVString());
        }
        return list.toArray(new String[0]);
    }

    public Collection<CustomField> getCustomFields(List<String> customFieldsXPaths) {
        HashMap<String, CustomField> customFields = new HashMap<String, CustomField>();
        for (String xpath : customFieldsXPaths) {
            String[] xpathSplit;
            if (!xpath.contains("CustomField{") || (xpathSplit = xpath.split("==")).length < 2) continue;
            if (xpathSplit[0].contains(VALUE)) {
                int index = xpathSplit[0].lastIndexOf("/");
                CustomField customField = this.getCustomField(customFields, xpathSplit[0], xpathSplit[0].substring(index + 1));
                String customFieldValue = xpathSplit.length != 2 ? "" : xpathSplit[1];
                customField.setValue(customFieldValue);
                continue;
            }
            if (!xpathSplit[0].endsWith("/@name")) continue;
            CustomField customField = this.getCustomField(customFields, xpathSplit[0], "@name");
            customField.setName(xpathSplit[1]);
        }
        return customFields.values();
    }

    private CustomField getCustomField(Map<String, CustomField> customFields, String xPath, String attributeKey) {
        String xPathWithoutAttribute = xPath.substring(0, xPath.lastIndexOf("/" + attributeKey));
        CustomField customField = customFields.get(xPathWithoutAttribute);
        if (customField == null) {
            customField = new CustomField(xPathWithoutAttribute);
            customFields.put(xPathWithoutAttribute, customField);
        }
        return customField;
    }
}

